<?php

/**
 * Files manipulation functions.
 * Basic usage : filter_xxx(get_files($dir))
 */

function file_extension($filename) {
	return end(explode(".", $filename));
}

function get_files($dir) {
	$ret = array();

   $old_dir = getcwd();
	chdir($dir) or die("get_dirs: cannot chdir to $dir");

	$d = opendir('.');
	while ($file = readdir($d)){
		if($file[0] == ".")
			continue;
		$ret[] = array('path' => $dir, 'name' => $file);
	}

	chdir($old_dir);
	return $ret;
}

function filter_dirs($files, $limit = 0) {
	$ret = array();
	$count = 0;

	foreach($files as $file) {
		if(is_dir($file['path'].'/'.$file['name'])) {
			//TODO Change to: is in $dir/cache.json, $dir = file(path).parent...
			//$file['json'] = file_exists($file['path'].'/'.$file['name'].'/cache.json');
			$ret[] = $file;
			$count++;
			if($count == $limit)
				break;
		}
	}
	
	rsort($ret);
	return $ret;
}

function filter_pics($files, $limit = 0) {
	$ret = array();
	$count = 0;

	foreach($files as $file) {
		$file_ext = file_extension($file['name']);
		if($file_ext == "jpg" || $file_ext == "JPG" || $file_ext == "PNG" || $file_ext == "png" || $file_ext == "gif" || $file_ext == "GIF") {
			//$is_mini=substr($file['name'],-6,2);
			//if($is_mini!="_m" && $is_mini!="_b" && $is_mini != "_c") {
				$ret[] = $file;
				$count++;
				if($count == $limit)
					break;
			//}
		}
	}

	return $ret;
}

function filter_movies($files, $limit = 0) {
	$ret = array();
	$count = 0;

	foreach($files as $file) {
		$file_ext = strtolower(file_extension($file['name']));
		if($file_ext == "mp4" || $file_ext == "ogv" || $file_ext == "ogg" || $file_ext == "avi") {
			$ret[] = $file;
			$count++;
			if($count == $limit)
				break;
		}
	}
	return $ret;
}

function filter_gpx($files, $limit = 0) {
	$ret = array();
	$count = 0;

	foreach($files as $file) {
		$file_ext = strtolower(file_extension($file['name']));
		if($file_ext == "gpx") {
			$ret[] = $file;
			$count++;
			if($count == $limit)
				break;
		}
	}
	return $ret;
}

function simplify($path) {
	$r = array();
	foreach(explode('/', $path) as $p) {
		if($p == '..') {
			if(count($r) == 0 || $r[count($r) - 1] == '..') 
				$r[] = $p;
			else
				array_pop($r);
		} else if($p != '.' && strlen($p))
			$r[] = $p;
	}
	$r = implode('/', $r);
	if($path[0] == '/') $r = "/$r";
	return $r;
}

function rrmdir($dir) {
	if (is_dir($dir)) {
		$objects = scandir($dir);
		foreach ($objects as $object) {
			if ($object != "." && $object != "..") {
				if (filetype($dir."/".$object) == "dir") rrmdir($dir."/".$object); else unlink($dir."/".$object);
			}
		}
		reset($objects);
		rmdir($dir);
	}
}

function get_json_dir($dirname) {
	global $jsons_dir;
	$dirname = simplify($dirname);
	return str_replace("../pics", $jsons_dir, $dirname);
}

function get_thumb_dir($dirname) {
	global $thumbs_dir;
	$dirname = simplify($dirname);
	return str_replace("../pics", $thumbs_dir, $dirname);
}
?>
