<?php

class LiteTemplate{
	var $tplName;
	var $tpl;
	var $time;
	var $cache_folder;
	var $cache_life;
	var $cache_activate;
	var $cache_compression;
	var $cache_isExpired;
	var $debug;
	var $error;
	var $version;
	function LiteTemplate(){
		$this->version = '1.9';
		$this->tpl = '';
		$this->tplName = '';
		$this->time = microtime();
		// cache
		$this->cache_folder = '_cache/';
		$this->cache_life = '60'; 
		$this->cache_activate = false; 
		$this->cache_compression = false;
		$this->debug = false;
		$this->cache_isExpired = true;
		$this->error = array();
	}

	function file($file){
		$this->tplName = $file;
		if($this->isExpiredCache()){
			$this->cache_isExpired = true;
			if (!$this->tpl = file_get_contents($file)){
				$this->error[] = 'Warning! problme lors de la rcupration du fichier '.$file;
			}
		} else {
			$this->cache_isExpired = false;
		}
		return $this;
	}

	function assign($tag_array){
		if(!$this->cache_activate or $this->cache_isExpired){
			foreach( $tag_array as $key => $value){

            $this->tpl = str_replace('{$'.$key.'}', $value,$this->tpl);
            if($value == true) {
               $this->tpl = preg_replace('/{if '.$key.'}(.*?){fi}/si', '${1}', $this->tpl);
            } else {
               $this->tpl = preg_replace('/{if '.$key.'}(.*?){fi}/si', '', $this->tpl);
            }
			}
		}
	}

	function assignTag($tag,$id,$tag_array){
		if(!$this->cache_activate or $this->cache_isExpired){
			if( $this->checkArray($tag_array) ){

				reset($tag_array);
				$num_key = count($tag_array); 
				$num_value = count($tag_array[key($tag_array)]); 
				$tmp = $this->findTag($tag,$id); 

				for($i=0;$i<$num_value;$i++){
					$array[$i] = $tmp;
					reset($tag_array);
					for( $j=0;$j<$num_key;$j++){
						$array[$i] = str_replace('{$'.key($tag_array).'}',str_replace('$','&#36;',$tag_array[key($tag_array)][$i]),$array[$i]);
						next($tag_array);
					}
				}

				for ($i=1;$i<count($array);$i++){
					$array[0] .= $array[$i];
				}

				$replace = '{'.$tag.' id='.$id.'}'.$tmp.'{/'.$tag.'}';
				$this->tpl = str_replace($replace,$array[0],$this->tpl);
			} else {
				$this->error[]="Warning! Array size is wrong $tag id=$id";
			}
		}
	}

	function assignInclude($id,$file=""){
		if(!$this->cache_activate or $this->cache_isExpired){
			if( empty($file) ){

				$filename = $this->findTag("INCLUDE",$id,"FILE") or exit("erreur sur la balise $id");

				$tmp = $this->getIncludeContents($filename);
				$this->tpl = str_replace("{INCLUDE id=$id file=$filename}",$tmp,$this->tpl);
			}
			else{

				$tmp = $this->getIncludeContents($file);
				$this->tpl = str_replace("{INCLUDE id=$id}",$tmp,$this->tpl);
			}
		}
	}

	function htmlSelect($name,$array,$selected="",$htmlAttribut=""){
		if(!$this->cache_activate or $this->cache_isExpired){
			$select = $this->findTag("HTMLSELECT",$name,"SELECTED");

			if(!$select){
				if($this->findTag("HTMLSELECT",$name)){

					$tmp = $this->creatHtmlSelect($name,$array,$selected,$htmlAttribut);
					$this->tpl = str_replace("{HTMLSELECT id=$name}",$tmp,$this->tpl);
				}
				else{

					$this->error[] = "Warning : Impossible de trouver HTMLSELEC $name";
				}

			}
			else{
				$tmp = $this->creatHtmlSelect($name,$array,$select,$htmlAttribut);
				$this->tpl = str_replace("{HTMLSELECT id=$name selected=$select}",$tmp,$this->tpl);
			}
		}
	}


	function view(){
		if(!$this->cache_activate or $this->cache_isExpired){
			$this->assignAutoInclude();
			if(!$this->debug){ $this->clearTag(); }
		}
		if(!$this->cache_activate){
			echo $this->tpl;
		}
		elseif($this->cache_isExpired){
			$this->putCache($this->returnTpl());
			echo $this->tpl;
		}
		else{
			echo $this->getCache();
		}
		$this->time = $this->microTimeDiff($this->time,microtime());
	}

	function writeTo($file) {
		$fh = fopen($file, 'w');
		if(!$fh) {
			die("Cannot open $file for writing");
		}
		fwrite($fh, $this->tpl);
		fclose($fh);
	}

	function returnTpl(){
		return $this->tpl;
	}

	function getCache($filename=''){

		$filename = (empty($filename))?$this->tplName:$filename;

		$filename_md5 = md5($filename);
		$path_file = $this->cache_folder.$filename_md5;

		if(file_exists($path_file)){

			if(!$this->cache_compression){

				$handle = fopen ($path_file, "rb");
				$contents = fread ($handle, filesize ($path_file)+1);
				fclose ($handle);
			}
			else{

				$contents =  $this->getGzFile($path_file);
			}

			return $contents;

		} else {
			return false;
		}

	}

	function putCache($contents,$filename=''){
		$filename = (empty($filename))?$this->tplName:$filename;

		if(!is_dir($this->cache_folder)) {
			if(!mkdir($this->cache_folder, 0755)){
				$this->error[] = 'Warning! Cache folder "'.$this->cache_folder.'" cannot be created';
			}
		} 

		$filename_md5 = md5($filename);
		$path_file = $this->cache_folder.$filename_md5;

		if(!$this->cache_compression){
			$handle = fopen ($path_file, "w");
			if (fwrite($handle, $contents) === FALSE) {
				$this->error[] = "Warning :fwrite fail $path_file";
			}
			fclose ($handle);
		} else {
			$handle = gzopen ($path_file, "w");
			if (gzputs($handle, $contents) === FALSE) {
				$this->error[] = "Warning :gzputs fail ".$path;
			}
			gzclose ($handle);
		}

	}

	function version($value="0"){
		if($value){
			return array('autor'=>'telnes',
				'version'=>$this->version, 
			);
		} else {
			return 'Page gnr avec LiteTemplate'.$this->version.', un moteur de template - cration telnes';
		}
	}


	function getError(){
		return $this->error;
	}

	function getIncludeContents($filename) {
		if (is_file($filename)) {

			ob_start();
			include $filename;
			$contents = ob_get_contents();
			ob_end_clean();
			return $contents;
		}
	}


	function getGzFile($filename){
		if (is_file($filename)) {

			ob_start();
			readgzfile($filename);
			$contents = ob_get_contents();
			ob_end_clean();
			return $contents;
		}
	}

	function findTag($tag,$id,$option=""){
		if( empty($option) ){
			@preg_match("/(\{".$tag." id=)(".$id.")(})(.*?)(\{\/".$tag."})/ism",$this->tpl,$result);
			if(empty($result[4])){
				preg_match("/\{".$tag." id=(".$id.")}/ism",$this->tpl,$result);
				return $result[1];

			}
			return $result[4];

		}
		elseif($option == "FILE"){
			@preg_match("/\{".$tag." id=".$id." file=(.*?)}/ism",$this->tpl,$result);
			return $result[1];
		}
		elseif($option == "SELECTED"){
			@preg_match("/\{".$tag." id=".$id." selected=(.*?)}/ism",$this->tpl,$result);
			return $result[1];
		}
		else{

			return 0;
		}
	}


	function checkArray($array){
		reset($array);
		$return = true;
		$num = count($array[key($array)]);

		for ($i = 0; $i < count($array); $i++) {

			if($num != count($array[key($array)])){

				$return=false;
			}

			next($array);
		}

		return $return;
	}

	function clearTag(){

		$tag = '[a-zA-Z0-9_]{1,}';
		$id = '[a-zA-Z0-9_]{1,}';

		$this->tpl = preg_replace('/\{\$'.$tag.'\}/i','',$this->tpl);
		$this->tpl = preg_replace('/(\{'.$tag.' id=)('.$id.')(})(.*?)(\{\/'.$tag.'})/ism','',$this->tpl);
		$this->tpl = preg_replace('/(\{'.$tag.' id=)('.$id.')(})/ism','',$this->tpl);
		$this->tpl = preg_replace('/(\{'.$tag.' id=)('.$id.') (file=(.*?)})/ism','',$this->tpl);
	}

	function microTimeDiff($time_begin,$time_end){
		$a=explode(' ',$time_begin);
		$b=explode(' ',$time_end);

		return $b[0]-$a[0]+$b[1]-$a[1];
	}

   function createInput($meta) {
      if($meta['type'] == 'select') {
         return $this->creatHtmlSelect($meta['id'], $meta['vals'], (empty($meta['val'])?$meta['default']:$meta['val']));
      } else {
         return '<input type="'.$meta['type'].'" name="'.$meta['id'].'" value="'.(empty($meta['val'])?$meta['default']:$meta['val']).'" '.(($meta['type'] == 'checkbox' && $meta['val'] == true)?'checked':'').'/>';
      }
   }

	function creatHtmlSelect($name,$array,$selected,$attribut=''){
		$tmp = '<Select name="'.$name.'" '.$attribut.' >'."\n";

		foreach($array as $key=>$value){

			if( $key == $selected){
				$tmp .= '<option value="'.$key.'" SELECTED >'.$value.'</option>'."\n";
			}
			else{
				$tmp .= '<option value="'.$key.'">'.$value.'</option>'."\n";	
			}	
		}
		$tmp .= '</select>';
		return $tmp;	
	}

	function assignAutoInclude(){


		$patern = "@\{INCLUDE file=(.*)\}@";
		preg_match_all($patern,$this->tpl,$tmp);

		foreach($tmp[1] as $file){

			$tmp = $this->getIncludeContents($file);
			$this->tpl = str_replace("{INCLUDE file=$file}",$tmp,$this->tpl);

		}

	}

	function isExpiredCache($filename=''){

		$filename = (empty($filename))?$this->tplName:$filename;

		$filename_md5 = md5($filename);
		$path_file = $this->cache_folder.$filename_md5;

		if(file_exists($path_file)){
			clearstatcache();
			$diff = time() - filemtime($path_file);

			if( $diff < $this->cache_life)
				return false;
			else{
				return true;
			}
		}

		else{
			return true;
		}

	}


	function showPage($name) {
		global $pages, $lang, $AVERSION;
		if(!isset($lang))
			$lang = 'en';

		$this->file('./common/tpl/header.tpl');
		$innerpage = new liteTemplate();
		$this->assign(array(
			'VERSION' => $AVERSION,
			'page' => $name,
			'lang' => $lang,
			'content' => $innerpage->file("./pages/$name/tpl/main.tpl")->returnTpl(),
			'CURRENT' => isset($pages[$name])?$pages[$name]['descr']:'',
		));

		$urls = array();
		$descrs = array();
		$names = array();
		foreach($pages as $p=>$meta) {
			if(!isset($meta['url']))
				continue;
			$urls[] = $meta['url'];
			$descrs[] = $meta['descr'];
			$names[] = $p;
		}
		$this->assignTag('BALISE', '1', array(
			'URL' => $urls,
			'DESCR' => $descrs,
			'NAME' => $names,
		));
	}
}



?>
