/**
 * Make sure you write the file in latin1 
 */
var known_sentences = {
   /** Header **/
   'Index':'Index',
   'Face Recognition':'Face Recognition',
   'Options':'Options',
   'Installation':'Installation',
   'Update':'Update',
   'update_gal':'Your gallery is outdated. <a href="index.php?action=options.updategal&nversion={0}&oversion={1}">Update</a> automatically or <a href="http://download.en-vadrouille.net/latest.zip">download</a> the last version.',

   /** Index **/
	'updating': function(params) {
      if(params)
         return 'Updating... ('+params[0]+'/'+params[1]+')';
      else
         return 'Updating...';
   },
	'writing_cache': 'Writing cache...',
	'gen_missing_thumbs':'Generate Missing Thumbs',
	'wait_thumb':function(params) {
      if(!params) 
         return 'Please wait, generating thumbs might take a long time...';
      else
         return 'Please wait, generating thumbs might take a long time... (Done: '+params[0]+'/'+params[1]+')';
   },
	'wait_clean':function(params) {
      if(!params) 
         return 'Please wait, cleaning cache might take a long time...';
      else
         return 'Please wait, cleaning cache might take a long time... (Done: '+params[0]+'/'+params[1]+')';
   },
	'rem_cache_orig':'Remove useless cached entries',
	'rem_cache':'{0} useless cache entries removed',
	'add_dir': 'Add directory',
	'up_dir': 'Update directory',
	'descr' : 'Descr:',
	'gps' : 'GPS:',
	'up_gpx' : 'Choose GPX',
	'rm_gpx' : 'Remove',
	'Uploading...': 'Uploading...',
	'starred': 'Starred:',
	'hidden': 'Hidden:',
	'up_thumb':'Upload a new thumbnail',
	'drop_thumb':'Drop picture here',
	'th_dir':'Choose a new thumbnail',
	'sending_thumb':'Sending thumbnail...',
	'uploading_gpx':'Uploading GPX file...',
	't_added_gpx':'(If you have put a GPX file in this directory, it will be automatically added.)',
   'cancelt_dir':'Cancel',
	'index_button_descr':'Use these buttons to perform global maintenance on the server. Since these operation parse all directories, they might take a long time (if you have added pictures in only one directory, it is faster to update the directory alone)',
   'expl_tick':'The directory has already been added (you may still want to update it if you have added/removed pictures)',
   'expl_mod':'The directory information has been modified but not sent on the server',
   'expl_cross':'The directory has not yet been added. Nobody can access it.',
   'advanced_b':'Advanced Options',
   'gen_descr':'Look in all directories for missing thumbnails and create them if needed. Use this option if you have added pictures in multiple directories',
   'clean_descr':'Look in the cache directories for entries that are no longer required (e.g., thumbnails of deleted pictures) and remove them',



   /** Facial recognition **/
	'remaining_faces':function(params) {
      //params = [ #known faces, #total faces, #faces used for training, #unparsed_dir (-1 = unknown) ]
		if(params[0] == 0 && params[1] == 0 && params[3] == 0)  {
			message = 'No face has been found in your directories.';
		} else if(params[0] == 0 && params[1] == 0 && params[3] != 0) {
			message = 'You have not recognized any face yet. You can begin by analysing directories (button at the bottom of the page).';
		} else if(params[0] == params[1] && params[3] == -1) {
			message = 'No face left to recognize. You can still analyse directorie(s) (button at the bottom of the page).';
		} else if(params[0] == params[1] && params[3] != 0) {
			message = 'No face left to recognize. '+params[3]+' directorie(s) have to be analysed.';
		} else if(params[0] == 0 && params[1]!=0) {
			message = 'You have not recognized any face yet. Type a name under a face to start facial recognition.<br/>'
				+ 'Tip: Use the TAB key to add a face, the SUPPR key to delete it and arrows to autocomplete the name';
		} else if(params[0]!=params[1]) {
			message = params[0]+' faces have been recognized and '+(params[1]-params[0])+' are still unknown';
			if(params[3] > 0)
				message += ' and '+params[3]+' directories contain pictures that have not been analysed';
		} else {
			message = 'No face left to recognize.';
		}
		return message;
	},

   'action_fail':function(params) {
      var tag = params[0].replace(/./g, '');
      var show_explain = $('#explain_'+tag).css('display') || 'none';
      return 'Action '+params[0]+' failed (<a href="#" onclick="javascript:if($(\'#explain_'+tag+'\').css(\'display\') == \'block\') $(\'#explain_'+tag+'\').css(\'display\', \'none\'); else $(\'#explain_'+tag+'\').css(\'display\', \'block\');return false;" style="text-decoration:none;border-bottom:1px dotted black;color:#D8000C;">details</a>)'
         +'<div id="explain_'+tag+'" style="display:'+show_explain+'"><pre>This action has failed '+params[3]+' time(s).\nLast params:\n'+dump(params[1])+'\nLast answer:\n'+params[2].responseText+'</pre></div>';
   },
      
	'error_file':'No face has been found. Analyse directories to start facial recognition.',
    
	'trained_faces':function(params) {
		message = params[0]+' faces have been added for automatic face recognition';
		if(params[1])
			message += ' (still doing work in background...)';
		return message;
	},
   'analyse_dir': 'Analyse directory ({0} pictures not analysed)',
   'get_unparsed': function(params) {
      if(params &&params[0] > 1)
         return params[0]+' directories are being analysed';
      else if(params)
         return params[0]+' directory is being analysed';
      else
         return 'Get directories that have not been analysed yet';
   },


   
	/** Options **/
   'opt_change_success':'Options have been successfully changed',
   'opt_change_required':'The administration has been updated. Please revalidate the options.',
   'opt_change_fail':'Cannot write the configuration file. Please check that a config.php file can be created in the /admin directory.',
   'opt_change_fail2':'Cannot write the index.html file. Please check that the ../index.html file is writtable.',
   'Global':'Global Administration Settings',
   'adm_pwdv':'Admin password',
   'langv':'Language',
   'gpx_typev':'Default Map Style',
   'UserOpt':'Global Gallery Settings',
   'uthemev':'Theme',
   'ulangv':'Language',
   'Thumbs':'Thumbs',
   'big_pic_widthv':'Thumbnail max width',
   'big_pic_heightv':'Thumbnail max height',
   'qualityv':'Thumbnail jpg quality',
   'Face_Recognition':'Face Recognition',
   'show_facev':'Do face recognition',
   'face_pubv':'Face.com API public key',
   'face_secretv':'Face.com API private key',
   'face_namespacev':'Face.com namespace',
   'ImageMagick':'ImageMagick',
   'convertv':'Path to ImageMagick',
   'face_err':'Please specify a face.com public/private key and a namespace first',
   'Submit':'Submit',
};

String.prototype.format = function(args) {
  return this.replace(/{(\d+)}/g, function(match, number) { 
    return typeof args[number] != 'undefined'
      ? args[number]
      : match
    ;
  });
};

window.t = function(sentence, params) {
	var mesg = known_sentences[sentence];
	if(typeof sentence == 'function')
		return 'fun?';
	if(!mesg)
		if(sentence && params)
			return sentence.format(params);
		else if(sentence)
			return sentence;
		else 
			return 'bug';
	if(typeof mesg == 'function')
		return mesg(params);
	else if(params)
		return mesg.format(params);
	else
		return mesg;
};

(function( $ ){
  $.fn.translate = function(){
	  $.each(this, function(id, v) {
		  var obj= $(v);
		  if(obj.val && obj.val() != '') {
			  obj.val(t(obj.val()));
		  } else {
			  obj.html(t(obj.html()));
		  }
	  });
  }
})(jQuery);

$(document).ready(function() {
	$('.translate').translate();
});

