<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('session.use_trans_sid', 0);
ini_set('session.use_only_cookies', 1);


$AVERSION = '121204';

require_once('common/php/controller.php');
require_once('common/php/template.php');
require_once('common/php/files.php');
require_once('common/php/json.php');

if(file_exists("config.php")) {
   require_once("config.php");

   /* config.php needs to be updated */
   if(!isset($CVERSION) || $CVERSION < $AVERSION) {
      $pages = array('options' => array(
         'descr' => "Update",
         'pwdfree' => array('update', 'change'),
         'url' => "index.php?action=options.update",
      ));
      route(get_post('action', 'options.update'));
   /* everything looks ok, route the request */
   } else {
      route();
   }
   /* no config.php file at all, create it */
} else {
   $pages = array('options' => array(
      'descr' => "Installation",
      'pwdfree' => array('main', 'change'),
      'url' => "index.php?action=options",
   ));
   route(get_post('action', 'options'));
}

?>
