<?php

die("Facial recognition has been disabled");


set_include_path("./pages/face/php");
require_once("face.php");

function main_action() {
	$template = new liteTemplate();
	$template->showPage('face');
	$template->view();
}

function get_img_action($rewrite_url = true) {
   global $pics_dir, $faces_dir;
	// Face.com API doesn't work well with accents in URLs so we cannot give it the real URLs. We use this fake action and pass the real URLs as a parameters in base64.
	if(!isset($_GET['dir']) || !isset($_GET['img']))
		exit;
	$dir = base64_url_decode(($_GET['dir']));
	$img = base64_url_decode(($_GET['img']));
	if(!is_dir($dir)) {
		$dir = utf8_decode($dir);
		if(!is_dir($dir)) {
			die("Dir $dir does not exist");
		}
   }

   $dir = simplify($dir);
   if(strpos($dir, $pics_dir, 0) !== 0)
      if(strpos($dir, $faces_dir, 0) !== 0)
         die("$dir is not a valid directory");
   if(strpos($img, '/') !== FALSE)
         die("$img is not a valid image");

	if($rewrite_url) {
		$dir = get_thumb_dir($dir);
		$big_pic = substr($img, 0, -4).'_r.'.file_extension($img);
	} else {
		$big_pic = $img;
	}

	header("Content-Type: image/jpg");
	readfile($dir.'/'.$big_pic);
}

function get_img2_action() {
   get_img_action(false);
}

function get_todo_list_action() {
	$faces_to_generate = get_missing_faces(get_post('dir'));
	$subdirs = filter_dirs(get_files(get_post('dir')));
	echo myjson_encode(array(
		'faces' => $faces_to_generate,
		'dirs' => $subdirs,
	));
}

function create_faces_action() {
	$faces = create_faces(get_post('dir'),get_post('img'));
	echo myjson_encode(array(
		'json' => json_decode(file_get_contents(face_hash_json(get_post('dir'),get_post('img'))), true),
		'faces' => $faces,
	));
}
	
function write_faces_json_action() {
	write_faces_json(get_post('dir'));
	echo myjson_encode(array('success' => 'ok'));	
}

	
function add_people_action() {
	add_people(get_post('people'));
	echo myjson_encode(array('success' => 'ok'));	
}

function rename_people_action() {
	rename_people(get_post('new_people'), get_post('old_people'));
	echo myjson_encode(array('success' => 'ok'));	
}

function suppress_people_action() {
	suppress_people(get_post('people'));
	echo myjson_encode(array('success' => 'ok'));	
}

function add_face_action() {
	add_face(get_post('pic'), get_post('people'));
	echo myjson_encode(array('success' => 'ok'));	
}

function face_train_action() {
	$ret = face_train();
	echo myjson_encode($ret);
}

function face_search_action() {
	$ret = face_search(get_post('min', 0), get_post('max', 30));
	echo myjson_encode($ret);
}

function face_rec_action() {
	$ret = face_rec(get_post('dir'), get_post('img'));
	echo myjson_encode($ret);
}

?>
