<?php

try {
	require_once("FaceRestClient.php");
} catch(Exception $e) {
}

$face_api = null;

function get_faces_dir($dirname) {
	global $faces_dir;
	$dirname = simplify($dirname);
	return str_replace("../pics", $faces_dir, $dirname);
}

function face_hash_json($dir, $pic) {
	$base_name = substr($pic, 0, -4);
	return get_faces_dir($dir).'/'.$base_name.".json";
}

function face_hash_face($dir, $pic, $face) {
	$base_name = substr($pic, 0, -4);
	return get_faces_dir($dir).'/'.$pic.'.'.$face.".jpg";
}

function base64_url_encode($input) {
    return strtr(base64_encode($input), '+/', '-_');
}

function base64_url_decode($input) {
    return base64_decode(strtr($input, '-_', '+/'));
}
function face_url($dir, $pic) {
   //echo "$dir / $pic<br/>\n";
	$path_only = implode("/", (explode('/', $_SERVER["REQUEST_URI"], -1)));
   //die('http://'.$_SERVER['SERVER_NAME'].simplify($path_only).'/index.php?action=face.get_img&dir='.base64_url_encode(forceUTF8($dir)).'&img='.base64_url_encode(forceUTF8($pic)));
	return 'http://'.$_SERVER['SERVER_NAME'].simplify($path_only).'/index.php?action=face.get_img&dir='.base64_url_encode(forceUTF8($dir)).'&img='.base64_url_encode(forceUTF8($pic));
}
function face_url2($dir, $pic) {
	$path_only = implode("/", (explode('/', $_SERVER["REQUEST_URI"], -1)));
	return 'http://'.$_SERVER['SERVER_NAME'].simplify($path_only).'/index.php?action=face.get_img2&dir='.base64_url_encode(forceUTF8($dir)).'&img='.base64_url_encode(forceUTF8($pic));
}


function getFaces($dir, $pic) {
	global $face_api;
	$ret = array();

	if(file_exists(face_hash_json($dir, $pic))) {
		$tags = json_decode(file_get_contents(face_hash_json($dir, $pic)));
	} else {
		if(!is_dir(get_faces_dir($dir)))
			@mkdir(get_faces_dir($dir), 0777, true);
		$tags = $face_api->faces_detect(face_url($dir, $pic));
		if(!$tags || !isset($tags->status))
			die("Face.com did not answer our request (this happens from time to time). Abort.");
		if($tags->status != 'success')
			die("Unexpected face.com answer:"+print_r($tags));
		file_put_contents(face_hash_json($dir, $pic), json_encode($tags));
	}

	if (empty($tags->photos))
		return $ret;

	foreach ($tags->photos as $photo) { //foreach, but there is only 1
		if (empty($photo->tags))
			continue;

		$nb_tags = count($photo->tags);
		for($i = 0; $i < $nb_tags; $i++) {
			$ret[$i] = array(
				$photo->tags[$i]->center->x,
				$photo->tags[$i]->center->y,
				$photo->tags[$i]->width,
				$photo->tags[$i]->height
			);
		}
	}

	return $ret;
}

function getFaceRect($orig_w, $orig_h, $_face_w, $_face_h, $_center_x, $_center_y, $thumb_w, $thumb_h) {
	$extension_factor = 1.55; // We take a 55% border arround the face
	$face_w = (int)($_face_w*$extension_factor*$orig_w/100);
	$face_h = (int)($_face_h*$extension_factor*$orig_h/100);

	// Check that the width/height ratio is the same as that of the thumb
	// Increase the size of $face_w or $face_h is required
	if(((int)(100*$face_w/$face_h)) < ((int)(100*$thumb_w/$thumb_h))) {
		$face_w = (int)($face_h*$thumb_w/$thumb_h);
	} else if(((int)(100*$face_w/$face_h)) > ((int)(100*$thumb_w/$thumb_h))) {
		$face_h = (int)($face_w*$thumb_h/$thumb_w);
	}

	$center_x = (int)($_center_x*$orig_w/100);
	$center_y = (int)($_center_y*$orig_h/100);

	$left_x = (int)($center_x - $face_w/2);
	$top_y = (int)($center_y - $face_h/2);

	if($left_x < 0)
		$left_x = 0;
	if($left_x + $face_w > $orig_w)
		$face_w = $orig_w - $left_x;
	if($top_y < 0)
		$top_y = 0;
	if($left_x + $face_w > $orig_w)
		$face_w = $orig_w - $left_x;
	// Redo the ratio but decrease this time
	if(((int)(100*$face_w/$face_h)) < ((int)(100*$thumb_w/$thumb_h))) {
		$face_h = (int)($face_w*$thumb_h/$thumb_w);
	} else if(((int)(100*$face_w/$face_h)) > ((int)(100*$thumb_w/$thumb_h))) {
		$face_w = (int)($face_h*$thumb_w/$thumb_h);
	}


	return array($left_x, $top_y, $face_w, $face_h);
}

function create_faces($dir, $pic) {
	global $face_thumb_w, $face_thumb_h, $face_api, $face_pub, $face_secret;
	$face_api = new FaceRestClient($face_pub, $face_secret);
	$ret = array();

	$image = null;
	$orig_w = -1;
	$orig_h = -1;

	$faces = getFaces($dir, $pic);
	//print_r($faces);

	for($i = 0; $i < count($faces); $i++) {
		if(!file_exists(face_hash_face($dir, $pic, $i))) {
			if($image === null) {
				$image = imagecreatefromjpeg($dir.'/'.$pic);
				$orig_w = imagesx($image);
				$orig_h = imagesy($image);
			}

			$center_x = $faces[$i][0];
			$center_y = $faces[$i][1];
			$face_w = $faces[$i][2];
			$face_h = $faces[$i][3];

			list($src_x, $scr_y, $src_w, $scr_h) = getFaceRect($orig_w, $orig_h, $face_w, $face_h, $center_x, $center_y, $face_thumb_w, $face_thumb_h);

			$thumb = imagecreatetruecolor($face_thumb_w, $face_thumb_h);
			if(!imagecopyresampled($thumb, $image, 0, 0, $src_x, $scr_y, $face_thumb_w, $face_thumb_h, $src_w, $scr_h)) {
				continue;
			}

			imagejpeg($thumb, face_hash_face($dir, $pic, $i), 100);
			imagedestroy($thumb);
		}
		$ret[] = face_hash_face($dir, $pic, $i);
	}

	if($image !== null)
		imagedestroy($image);
	return $ret;
}

function get_missing_faces($dir) {
	$ret = array();
	$pics = filter_pics(get_files($dir));

	foreach($pics as $pic) {
		$json = face_hash_json($pic['path'], $pic['name']);
		if(!file_exists($json)) {
			$base_name = substr($pic['name'], 0, -4);
			$base_ext = file_extension($pic['name']);
			$big_pic = get_thumb_dir($pic['path']).'/'.$base_name.'_r.'.$base_ext;
			if(file_exists($big_pic)) //face.com uses the _r thumb
				$ret[] = $pic;		
		} 
	}
	return $ret;
}

function get_fjson($name) {
   global $pics_dir;
	$json_path = get_faces_dir($pics_dir).$name;
	if(file_exists($json_path)) {
		$json= json_decode(file_get_contents($json_path), true);
	} else {
		$json = array();
   }
   return $json;
}

function write_fjson($json, $name) {
	global $pics_dir;
	@mkdir(get_faces_dir($pics_dir));
   file_put_contents(get_faces_dir($pics_dir).$name, myjson_encode($json));
}

function write_faces_json($dir) {
	$json = get_fjson('/cache.json');
	$files = filter_pics(get_files(get_faces_dir($dir)));
	$json[$dir] = $files;
	write_fjson($json, '/cache.json');
}

function add_people($name) {
   if($name == "")
      return;

   $json = get_fjson('/people.json');
   if(!isset($json[$name]))
      $json[$name] = array();
	write_fjson($json, '/people.json');
}

function rename_people($new_name, $old_name) {
   if($new_name == "")
      return;

   $json = get_fjson('/people.json');
   if(!isset($json[$old_name])) {
      $json[$new_name] = array();
   } else {
      $json[$new_name] = $json[$old_name];
      unset($json[$old_name]);
   }
	write_fjson($json, '/people.json');
}

function suppress_people($name) {
   if($name == "")
      return;

   $json = get_fjson('/people.json');
   if(isset($json[$name]))
      unset($json[$name]);
	write_fjson($json, '/people.json');
}


function add_face($pic, $name) {
   if($name == "")
      return;

   $json = get_fjson('/people.json');
   if(!isset($json[$name]))
      $json[$name] = array();

   foreach($json as $n=>$v)
      foreach($json[$n] as $p=>$data) {
         if($p == $pic)
            unset($json[$n][$p]);
      }
         
   $json[$name][$pic] = array();
	write_fjson($json, '/people.json');
}


function getTrainingUrls($json_trained, $json_known, $name) {
   $ret = array( 'urls' => array(), 'pics' => array() );
   $known_pics = $json_known[$name];
   foreach ($known_pics as $pic=>$metadata) {
      if(isset($json_trained[$pic]))
         continue;
      $ret['urls'][] = face_url2(dirname($pic), basename($pic));
      $ret['pics'][face_url2(dirname($pic), basename($pic))] = $pic;
   }
   return $ret;
}

function getAllPics() {
   $ret = array();
   $json = get_fjson('/cache.json');
   foreach($json as $dir=>$pics) {
      foreach($pics as $pic) {
         $ret[] = face_url2($pic['path'], $pic['name']);
      }
   }
   return $ret;
}

function face_train() {
	global $face_pub, $face_secret, $face_namespace;
   $api = new FaceRestClient($face_pub, $face_secret);

   $json_trained = get_fjson('/trained.json');
   $json_known = get_fjson('/people.json');
   unset($json_known['trash']);

   $done = 0;
   $ret_tags = array();
   $error_tags = array();
   foreach($json_known as $name=>$pics) {
      $aurls = getTrainingUrls($json_trained, $json_known, $name);
      $urls = $aurls['urls'];
      if(count($urls) == 0)
         continue;
	  $done += count($urls);

      $uid = $name.'@'.$face_namespace;
      $urls = array_splice($urls, 0, 5);
      $tags = $api->faces_detect($urls);
      if (empty($tags->photos)) {
         $error_tags[] = array('descr' => 'no photo returned', 'urls' => $urls);
         continue;
      }

      $tids = array();
      foreach ($tags->photos as $photo) {
         $json_trained[$aurls['pics'][$photo->url]] = $uid;
         if (empty($photo->tags) || (count($photo->tags) > 1)) {
            $error_tags[] = array('descr' => 'no tag or multiple tags found', 'url' => print_r($photo, true));
            continue;
         }
         $tid = $photo->tags[0]->tid;
         $tids[] = $tid;
      }
      if (count($tids) > 0) {
         $res1 = $api->tags_save($tids, $uid, $uid);
         $res2 = $api->faces_train($uid);
         $ret_tags[] = array('res1' => print_r($res1, true), 'res2' => print_r($res2, true), 'urls' => $urls);
	  }
      if($done >= 5)
         break;
   }


   write_fjson($json_trained, '/trained.json');
   return array('done' => $done, 'res' => $ret_tags, 'errors' => $error_tags);
}

function get_registered_users() {
	global $face_pub, $face_secret, $face_namespace;
	return file_get_contents("http://api.face.com/account/users.json?api_key=$face_pub&api_secret=$face_secret&namespaces=$face_namespace");
}	

function face_search($min,$max)
{
   global $face_pub, $face_secret, $face_namespace;
   $api = new FaceRestClient($face_pub, $face_secret);

   $json_known = get_fjson('/people.json');
   unset($json_known['trash']);

   $json_uid = json_decode(get_registered_users(), true);
   $uids = $json_uid['users'][$face_namespace];

   $photoUrls = getAllPics();

   $urls = array();
   $count = 0;
   foreach ($photoUrls as $photoUrl)
   {
      $count++;
      if($count < $min || $count > $max)
         continue;
      $urls[] = $photoUrl;
      if ((count($urls) % 30) == 0 || $count==$max || $count == count($photoUrls))
      {
         $response = $api->faces_recognize($urls, $uids);

         foreach ($response->photos as $photo)
         {
            //skip empty tags and errors
            if (empty($photo->tags))
               continue;
            $url = $photo->url;
            //echo all found tags
            foreach ($photo->tags as $tag)
            {
               if (!empty($tag->uids))
               {
                  echo "<table><tr><td><img src='$url' /></td><td>";
                  foreach($tag->uids as $t) {
                     $uid = $t->uid;
                     $conf = $t->confidence;
                     echo "$uid was found ($conf % confidence)<br/>";
                  }
                  echo "</td></tr></table>";
               }
            }
         }
         $urls = array();
      }
   }
}



function face_rec($dir,$pic)
{
   global $face_pub, $face_secret, $face_namespace;
   $api = new FaceRestClient($face_pub, $face_secret);

   $ret = array();

   $json_uid = json_decode(file_get_contents("http://api.face.com/account/users.json?api_key=$face_pub&api_secret=$face_secret&namespaces=$face_namespace"), true);
   $uids = $json_uid['users'][$face_namespace];
   if(count($uids) == 0)
	   return array('no uid');

   $urls = array();
   $urls[] = face_url2($dir, $pic);
   $response = $api->faces_recognize($urls, $uids);
   if(!isset($response->photos)) {
      print_r($response, true);
      return $ret;
   }
   foreach ($response->photos as $photo) {
      if (empty($photo->tags))
         continue;
      foreach ($photo->tags as $tag) {
         if (!empty($tag->uids)) {
            foreach($tag->uids as $t) {
               $uid = $t->uid;
               $conf = $t->confidence;
               $ret[] = array('uid' => str_replace('@'.$face_namespace, "", $uid), 'confidence' => $conf);
            }
         }
      }
   }
   return array('uids'=> $ret, 'ret' => print_r($response, true));
}
