/* TODO:
 * - Check why face_rec sometimes fail          (<- never happens anymore?)
 * - Check that all faces are correctly trained (<- seems ok)
 * - See whether it is possible to rename/suppress a training set or a picture in a training set in the face.com API. Currently one mistake in tagging = face rec might get confused forever...
 * - Better interaction with the face.com API -> see wether we can suppress the trained file (get the training set directly ?)
 * - A way to suppress the cache.json ? 
 * - Add analysed faces in the global view directly. Check if the view is the global view before doing so.
 * - Modify the way cache.json & people.json work. Create a people/name/cache.json per name and a /dirs/name/cache.json per directory
 */

/*
 * Overview:
 * - Three main activities : showing faces, doing automatic face recognition and showing people.
 * - 'UIDs' are used to generate unique id tags for divs. 
 * - Before doing any work on face.tpl, look for 'parent()' and 'find()' calls in this file to know if the div hierarchy is important or not.
 */
$(document).ready(function() {
   var current_view = 'default'; // Shown faces. Default = untagged faces
   var trained_faces = 0;        // Number of trained faces since the beginning of the session
   var json_faces = [];          // Unknown faces
   var alread_parsed = { };      // Known faces
   var visible_faces = [];			// Visible faces
   var people = {};              // List of known people. Used for suggestion
   var people_cb = {};           // Hash of callbacks that have to be called when adding a face into a people's box.

   /********************************/
   /** Faces thumbnails functions **/
   /********************************/
   /** -> Model                   **/

   // Tell the server to associate a face zith a person
   function add_face(path, name, cb) {
      if(!people[name]) 
         add_people(name);
      
      var batch = new Batch(SequentialBatch, cb, null);
      batch.get({action:'face.add_face', people:name, pic:path}, function() {});
      batch.launch();
   }

   /** -> View                     **/

   // Make a thumbnail draggrable & clickable 
   // Make the name field autocompletable + add TAB, SUPPR & ENTER actions
   function add_face_action(uid) {
      $( '#'+uid ).draggable({
         revert: "invalid", 
         cursor: "move",
         appendTo: 'body',
         containment: 'window',
         cursorAt:{cursor:"move", top:25, left:25},
         helper:function() {
            $(this).css('opacity', 0.8);
            return $(this).clone(false).css('opacity', 1).css('zIndex', 3000).css('width', '50px').css('height', '50px');

         },
         stop:function() {
            $( '#'+uid ).css('opacity', 1);
         }
      });
	  var focused = false;
	  var e_ul = null;
      var e = $('#'+uid+'_name').autocomplete({
		   delay:0,
			source: function(request, response) {
            var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( request.term ), "i" );
				response( $.grep( $.keys(people), function( value ) {
                  return matcher.test( value );
				}));
         },
		   focus: function(event, ui) { 
				$('#'+ui.item.uid).parent().parent().find('.selected').removeClass('selected');
				$('#'+ui.item.uid).addClass('selected');
		   },
      }).keydown(function(evt) {
         if(evt.keyCode == 13 || evt.keyCode == 9) {
            $('#'+uid+'_name').autocomplete('close');
            if(add_thumb_into_people(uid, $('#'+uid+'_name').val()))
               $( '#'+uid ).draggable('disable');
         } else if(evt.keyCode == 46 && $('#'+uid+'_name').val() == "") {
            $('#'+uid+'_name').autocomplete('close');
            if(add_thumb_into_people(uid, 'trash'))
               $( '#'+uid ).draggable('disable');
         } 
      }).blur(function() {
		  focused = false;
	  });
	  e.data( "autocomplete" )._renderItem = function( ul, item ) {
		    if($(ul).find('#top').length == 0) {
				$(ul).append('<p id="top" class="triangle-border top"></p>');
			}
			if(!focused) {
				$(ul).find('p').stop().css('top', '-3px').css('opacity', 0).animate({top:'3px', opacity:1}, "fast");
				focused = true;
			}
			item.uid = getUID();
			$( "<li></li>" )
				.data( "item.autocomplete", item )
				.append( '<a id='+item.uid+'>'+item.label.replace(new RegExp("^("+$('#'+uid+'_name').val()+")(.*)$", "i"), "<em>$1</em>$2" )+'</a>' )
				.appendTo( $(ul).find('#top') );
			return $( "<li></li>" )
				.data( "item.autocomplete", item )
				.append( '<a style="display:none">'+item.label+'</a>' )
				.appendTo( $(ul) );
		};
   }

   /* Remove visible faces */
   function reinit_view(name) {
	   $("#loadTpl").tmpl().appendTo($('#faces').empty());
	   $('#options').css('display', 'none');
	   visible_faces = [];
	   current_view = name;
	   update_faces_slider();
   }

   /* Show/hide the slider on the right side of visible faces */
   function update_faces_slider() {
      var face_height = 135;
      var sliding_height = (Math.ceil(visible_faces.length / 9) - 3)*face_height;
	   if(sliding_height <= 0) {
         $('#face_overflow').css('height', Math.ceil(visible_faces.length / 9) * face_height);
		   $('#slider-faces').css('display', 'none');
	   } else {
         $('#face_overflow').css('height', 3 * face_height);
		   $( "#slider-faces" ).css('display', 'block').slider({
				orientation: "vertical",
				min: -sliding_height,
				max: 0,
				step:1,
				slide: function( event, ui ) {
               $('#face_container').css('top', ui.value);
				}
			});
	   }
   }

   /* Display a face; some parameters are legacy; actually only path and cb are used */
   function add_face_in_container(id, path, known_face, cb) {
      if(alread_parsed[path] && known_face !== true)
         return;

      var uid = getUID();
      $("#faceTpl").tmpl({thumb:path, id:uid}).appendTo($('#face_container'));
      add_face_action(uid);
      visible_faces.push(uid);
      update_faces_slider();

      if(cb) cb(uid);
   }
      
   /* Fetch and display faces of a known person */
   function add_known_faces(name) {
      reinit_view(name);
      $("#faceContainerTpl").tmpl().appendTo($('#faces').empty());
		
		var pics = people_cb[name]['pics'];
		$.each(pics, function(id, pic) {
			add_face_in_container(id, pic.pic, true, null);
		});

		$('#options').css('display', 'block').css('opacity', '1');
		if(name == 'trash') {
			$('#renamev').css('display', 'none');
			$('#renamep').css('display', 'none');
			$('#suppressp').css('display', 'none');
		} else {
			$('#renamev').css('display', 'inline');
			$('#renamep').css('display', 'inline');
			$('#suppressp').css('display', 'inline');
		}

      $('#renamev').val(name);
      $("#renamep").unbind('click').click(function() {
            rename_people($("#renamev").val(), name);
      });
      $("#suppressp").unbind('click').click(function() {
         suppress_people(name);
      });
      $('#unknownp').unbind('click').click(function() {
         get_unknown_faces('../cache/faces/cache.json');
      });


      cancel_all_facerec();
      complete_names_in_container(true);
   }

   /* Fetch the json with all unknown faces and display them */
   function get_unknown_faces(url) {
	   reinit_view('default');
	   json_faces = [];
	   get_json(url, function(data){
         $("#faceContainerTpl").tmpl().appendTo($('#faces').empty());
		   if(data.status) {
			   inform('remaining_faces', 'success', true, [$.keys(alread_parsed).length, json_faces.length, trained_faces, nb_unparsed_dirs]);
			   return;
		   }
		   $.each(data, function(url, arr) {
			   $.each(arr, function(id, img) {
				   json_faces.push(img.path+'/'+img.name);
			   });
		   });

		   $.each($(json_faces).get().reverse(), function(id, path) {
			   add_face_in_container(id, path, false, null);
		   });
		   inform('remaining_faces', 'success', true, [$.keys(alread_parsed).length, json_faces.length, trained_faces, nb_unparsed_dirs]);
		   cancel_all_facerec();
		   complete_names_in_container(false);
	   });
   }








   /********************************/
   /** Face autocompletion		   */
   /********************************/
   var facerec_batches = [];		// Currently pending face recs
   function cancel_all_facerec() {
	    for(var batch in facerec_batches) 
			facerec_batches[batch].cancel();
		facerec_batches = [];
   }
   /* Try to add names in the face inputs */
   function complete_name(id, inp, known, batch) { // id is not important, input = the input of the face image container for legacy reasons
	   var img = $(inp).parent().find('.face').attr('src');
	   if(known) {
		   $(inp).val(current_view);
	   } else if(alread_parsed[img]) {
		   //$(inp).val(alread_parsed[img]);
	   } else {
		   $(inp).addClass('sync');
		   batch.get({action:'face.face_rec', 'dir':dirname(img), 'img':basename(img)}, function(data) {
			   $(inp).removeClass('sync');
			   if(!data.uids) {
				   //error?
			   } else if(data.uids[0]) {
				   if(!$(inp).is(':focus') && !alread_parsed[img])
					   $(inp).val(data.uids[0].uid);
			   }
		   });
		   batch.launch();
	   }
   }
   function complete_names_in_container(known) {
      var inputs = $('#face_container').find('input');
      var batch = new Batch(ParallelBatch, function() {} , null);
      $.each(inputs, function(id, inp) {
	complete_name(id, inp, known, batch);
      });
      batch.launch();
      facerec_batches.push(batch);
   }

   /* Train in background	   */
   /* Launched every 3 seconds */
   var SequentialBatch2 = new BatchContainer(1);
   function train_faces() {
	  if(SequentialBatch2.batchPending) // do not stack background tasks
		  return;
      var batch = new Batch(SequentialBatch2, function() {}, null);
      batch.get({action:'face.face_train'}, function(data) {
	  if(data.status != undefined) { // error, retry in 15s
		  $.doTimeout(15000, function() {
			  train_faces();
		  });
	  } else {
		  if(data.done === undefined) {
			  inform('trained_faces', 'warning', true, [trained_faces]);
		  } else {
			  trained_faces += data.done;
			  inform('trained_faces', 'success', (trained_faces>0), [trained_faces, data.done]);
		  }
		  if(data.done === undefined || data.done == 0) {
			  $.doTimeout(3000, function() {
				  train_faces();
			  });
		  } else {
			  $.doTimeout(500, function() {
				  train_faces();
			  });
		  }
	  }
	  }, null);
      batch.launch();
   }







   /********************************/
   /** People related functions   **/
   /********************************/
   /** -> Model (sort of)         **/
   function add_people(name) {
      if(name == "" || people[name])
         return;
      people[name] = true;

      show_people(name, {});
      toggle_loading_people(name, true);

      var batch = new Batch(SequentialBatch, function(data) {
            toggle_loading_people(name, false);
      }, null);
      batch.get({action:'face.add_people', people:name}, function() {});
      batch.launch();
   }

   function rename_people(new_name, old_name) {
      if(new_name == "" || people[new_name])
         return;

      if(current_view == old_name)
         $("#options").css('opacity', '0');

      people[new_name] = people[old_name];
      delete people[old_name];
      people_cb[new_name] = people_cb[old_name];
      delete people_cb[old_name];

      var div = people_cb[new_name]['div'];
      div.find('#name').text(new_name);
      toggle_loading_people(new_name, true);
      
      var batch = new Batch(SequentialBatch, function(data) {
         toggle_loading_people(new_name, false);
         if(current_view == old_name) 
            add_known_faces(new_name);
      }, null);
      batch.get({action:'face.rename_people', old_people:old_name, new_people:new_name}, function() {});
      batch.launch();
   }

   function suppress_people(name) {
      if(current_view == name) {
         $("#loadTpl").tmpl().appendTo($('#faces').empty());
         $("#options").css('display', 'none');
      }

      delete people[name];
      $.each(people_cb[name]['pics'], function(id, img) {
            delete alread_parsed[img.pic];
      });
      people_cb[name]['div'].remove();
      inform('remaining_faces', 'success', true, [$.keys(alread_parsed).length, json_faces.length, trained_faces, nb_unparsed_dirs]);

      var batch = new Batch(SequentialBatch, function(data) {
         if(current_view == name)
            get_unknown_faces('../cache/faces/cache.json');
      }, null);
      batch.get({action:'face.suppress_people', people:name}, function() {});
      batch.launch();
	  update_people_slider();
   }

   function merge_people(old_name, new_name) {
      var pics = people_cb[old_name]['pics'];
      var tmp = [];
		$.each(pics, function(id, pic) {
            tmp.push(pic);
      });
      $.each(tmp, function(id, pic) {
            add_face(pic.pic , new_name, function() { });
            people_cb[new_name]['add_pic'](pic.pic);
            people_cb[old_name]['remove_pic'](pic.uid, pic.pic);
		});
   }

   function get_people(url) {
      get_json(url, function(data) {
            if(!data.status)
               people = data;
            if(!people['trash'])
               people['trash'] = { };
            $.each(people, show_people);

            /* We need to call that here. Before we don't know "known" faces */
            get_unknown_faces('../cache/faces/cache.json');
      });
   }

   /** -> View                    **/
   // Make a people box look busy / clear.
   // @loading true/false
   function toggle_loading_people(name, loading) {
      var div = people_cb[name]['div'];
      if(loading) {
         div.find('#pics').css('display', 'none');
         div.find('#options').css('display', 'none');
         div.find('#load').css('display', 'block');
      } else {
         div.find('#pics').css('display', 'inline');
         div.find('#options').css('display', 'block').css('opacity', '1');
         div.find('#load').css('display', 'none');
      }
   }

   function add_thumb_into_people(uid, name) {
      if(name == "")
         return false;

      /* Remove from another person if exists */
      var elt = $('#'+uid);
      var id = elt.attr('id');
      var old_name = alread_parsed[elt.attr('src')];
      if(old_name) {
        if(name == old_name)
          return false;
        if(people_cb[old_name])
           people_cb[old_name]['remove_pic'](id, elt.attr('src'));
      }

      /* Show loading */
      $(elt).animate({opacity:0.3}, "fast");
      $('#'+uid+'_div').parent().find("#ok").css('display', 'none');
      $('#'+uid+'_div').parent().find("#pending").css('display', 'block');

      /* Add into new people */
      add_face($(elt).attr('src') , name, function() {
            $('#'+uid+'_div').parent().find("#pending").css('display', 'none');
            $('#'+uid+'_div').parent().find("#ok").css('display', 'block');
      });
      people_cb[name]['add_pic'](elt.attr('src'));
      $('#'+uid+'_name').val(name);
	  inform('remaining_faces', 'success', true, [$.keys(alread_parsed).length, json_faces.length, trained_faces, nb_unparsed_dirs]);
	  return true;
   }

   /* Maybe the ugliest function of all...											   */
   /* Show a people box with its faces and declares handlers:	  
    * - add_pic : add a picture in a people box
	* - remove_pic : guess what
	* - all_pics : list of all faces of the person
	* These handlers can be accessed via:  people_cb[<peoplename>]['add_pic'](params); */
   /* (Yes, this is a way to do object oriented programming without really doing it...)*/
   function show_people(name, pics) {
      var muid = getUID();
      $("#peopleTpl").tmpl({id:muid,name:name}).appendTo($('#people'));

      var count = 0;
      var main_div = $('#'+muid); 
      var all_pics = [];

      function getName() { // Actually a people's name may change. Don't trust the 'name' parameter.
         return main_div.find('#name').text();
      }
	  function add_pic(pic) {
		  var uid = getUID();
		  if(count == 0 && getName() == 'trash') {
			  main_div.find('#main_img img').attr('src', 'pages/face/css/trash.png');
			  $("#miniFaceTpl").tmpl({id:uid,pic:pic}).appendTo(main_div.find('#pics'));
			  count++;
		  } else if(count == 0) {
			  main_div.find('#main_img img').attr('src', pic);
		  } else if(count < 3) {
			  $("#miniFaceTpl").tmpl({id:uid,pic:pic}).appendTo(main_div.find('#pics'));
		  }
		  count++;
		  all_pics.push({uid:uid,pic:pic});
		  alread_parsed[pic] = getName();
		  show_count();
	  }
	  function remove_pic(uid, pic) {
		  var elt = null,ind = -1;
		  $.each(all_pics, function(id, e) { if(e.pic == pic) { elt = e; ind = id;} });
		  if(!elt)
			  return;
		  all_pics.splice(ind, 1);
		  count--;
		  if(count == 0) {
			  suppress_people(getName());
		  } else {
			  var thumb = $.grep(main_div.find('#pics img'), function(img, n) { return $(img).attr('src') == pic; });
			  if(thumb.length > 0) {
				  $(thumb).remove();
				  if(all_pics.length > main_div.find('#main_img img').length+1) {
					  var new_t = all_pics[main_div.find('#main_img img').length+1];
					  $("#miniFaceTpl").tmpl({id:new_t.uid,pic:new_t.pic}).appendTo(main_div.find('#pics'));
				  }
			  } else if(main_div.find('#main_img img').attr('src') == pic) {
				  var subpic = main_div.find('#pics img').first();
				  if(subpic) {
					  main_div.find('#main_img img').attr('src', subpic.attr('src'));
					  subpic.remove();
					  if(all_pics.length > main_div.find('#main_img img').length+1) {
						  var new_t = all_pics[main_div.find('#main_img img').length+1];
						  $("#miniFaceTpl").tmpl({id:new_t.uid,pic:new_t.pic}).appendTo(main_div.find('#pics'));
					  }
				  } else if(all_pics.length > 0) {
					  main_div.find('#main_img img').attr('src',all_pics[0].pic);
				  }
			  }
		  }
		  show_count();
	  }
      function show_count() {
         size_count = Math.max(0, count-1);
         main_div.find('#plus').css('height', Math.max(26, 100-size_count*37)+'px').find('#p').css('top', Math.max(4, (100-size_count*37)/2-10)+'px').text('+'+(Math.max(0,count-3)));
      }
      people_cb[name] = {'add_pic':add_pic, 'show_count':show_count, 'remove_pic':remove_pic, 'pics':all_pics, 'div':main_div};



	  if(name == 'trash')
		  main_div.find('#main_img img').attr('src', 'pages/face/css/trash.png');
      main_div.find('#pics').empty();
      $.each(pics, function(pic, metadata) {
         add_pic(pic);
      });
      show_count();
      
      main_div.draggable({
         revert:"invalid",
         zIndex:3500,
      }).droppable({
         accept: ".draggable",
         activeClass: "ui-state-highlight",
         over:function() {
            main_div.find('#name').parent().stop().animate({opacity:1}, "slow");
         },
         out:function() {
            main_div.find('#name').parent().stop().animate({opacity:0}, "fast");
         },
         drop: function( event, ui ) {
            main_div.find('#name').parent().stop().animate({opacity:0}, "fast");
			ui.draggable.draggable('disable');
            if(ui.draggable.hasClass('face')) { // A face was dropped in the box
               if(!add_thumb_into_people(ui.draggable.attr('id'), getName()))
				   ui.draggable.draggable('enable');
            } else {						    // Another people box was dropped
               merge_people(ui.draggable.attr('id'), getName());
            }
         }
      }).click(function() {
		  add_known_faces(getName());
      });
	  update_people_slider();
   }

   var people_expanded = false;
   function update_people_slider() {
	   var max = Math.ceil($.keys(people).length / 7);
	   if(!people_expanded)
		   $('#people-container').css('height', Math.min(226, max*113)+'px');
	   else
		   $('#people-container').css('height', (max*113)+'px');
	   if(max > 2) {
		   $( "#slider-people" ).css('display', people_expanded?'none':'block').slider({
				orientation: "vertical",
				min: -$('#people').height()+2*113,
				max: 0,
				step:1,
				slide: function( event, ui ) {
					$('#people').css('top', ui.value+'px');
				}
			});
		   $( "#expand-people" ).css('display', 'block').unbind('click').click(function() {
			   $('#people').css('top', '0');
			   if($( "#slider-people" ).css('display') == 'block') {
				   people_expanded = true;
				   $('#people-container').css('height', (max*113)+'px');
				   $( "#slider-people" ).css('display', 'none');
				   $( "#expand-people" ).find('.expand').removeClass('expand').addClass('reduce');
			   } else {
				   people_expanded = false;
				   $('#people-container').css('height', Math.min(225, max*113)+'px');
				   $( "#slider-people" ).css('display', 'block');
				   $( "#expand-people" ).find('.reduce').removeClass('reduce').addClass('expand');
			   }
		   });
	   } else {
		   $( "#slider-people" ).css('display', 'none');
		   $( "#expand-people" ).css('display', 'none');
	   }
   }

   

   /********************************/
   /** Unparsed dirs			  **/
   /********************************/
   var nb_unparsed_dirs = -1;
   function get_unparsed_dirs() {
	  nb_unparsed_dirs = 0;

	  var nb_pending = 0;
	  var SequentialBatch3 = new BatchContainer(1);
	  var batch = new Batch(SequentialBatch3, function() {
		  $('#get_unparsed').attr('disabled', false).val(t('get_unparsed')).removeClass('get_unparsed_wait');
	  }, null);
	  function get_faces(dir) {
		   nb_pending++;
		   $('#get_unparsed').val(t('get_unparsed', [nb_pending]));
		   batch.get({action:'face.get_todo_list', dir:dir}, function(data) {
				   nb_pending--;
				   $('#get_unparsed').val(t('get_unparsed', [nb_pending]));
				   if(data.__params.dir && data.faces.length > 0) {
					   var uid = getUID();
					   var nb_unparsed_faces = 0;
					   $("#unparsedDirTpl").tmpl({id:uid,dir:data.__params.dir.replace('../pics/', ''),faces:data.faces,val:t('analyse_dir', [data.faces.length])}).appendTo($('#unparsed_dirs'));
					   $("#"+uid+' input').click(function() {
						   $("#"+uid+' input').attr('disabled', true).removeClass('an_dir').addClass('an_load_dir');;
						   var batch2 = new Batch(ParallelBatch, function() {
							   $("#"+uid+' input').removeClass('an_load_dir').addClass('an_dir').val('Analysed');
							   $("#"+uid).addClass('dirtable_an');
						   }, null);
						   var batch3 = new Batch(ParallelBatch, function() {}, null);
						   for(var face in data.faces) {
							   batch2.get({action:'face.create_faces', dir:data.__params.dir, img:data.faces[face]['name']}, function(data2) {
								   nb_unparsed_faces++;
								   $("#"+uid+' input').val(t('analyse_dir', [data.faces.length - nb_unparsed_faces]));
								   if(current_view == 'default' && data2.faces) {
									   for(f in data2.faces) {
										   add_face_in_container(getUID(), data2.faces[f], false, function(uid) {
											complete_name(uid, $('#'+uid+'_container').find('input'), false, batch3);
										   });
									   }
								   }
								   //TODO: add in unknown faces!
							   }, null);
						   }
						   batch2.get({action:'face.write_faces_json', dir:data.__params.dir}, function() {
							   //TODO:?
						   });
						   batch2.launch();
						   batch3.launch();
						   facerec_batches.push(batch3);
					   });

					   nb_unparsed_dirs++;
				   }
				   inform('remaining_faces', 'success', true, [$.keys(alread_parsed).length, json_faces.length, trained_faces, nb_unparsed_dirs]);
				   for(var dir in data.dirs) {
					   get_faces(data.dirs[dir].path+'/'+data.dirs[dir].name);
				   }
		   }, null);
		   batch.launch();
	  }
	  get_faces();
   }
	
   $('#get_unparsed').click(function() {
         $('#get_unparsed').attr('disabled', true).addClass('get_unparsed_wait');
         $('#unparsed_dirs').empty();
         get_unparsed_dirs();
   });

   /* Launch */
   get_people('../cache/faces/people.json'); //calls get_unknown_faces
   train_faces();
});

