<?php

set_include_path("./pages/index/php");
require_once("files.php");
require_once("thumbs.php");
require_once("json.php");

function main_action() {
   global $gpx_type;
	$template = new liteTemplate();
   $template->showPage('index');
   $template->assign(array('DEFAULT_GPX' => $gpx_type));
	$template->view();
}

function get_dir_content_action() {
	$thumb_dir = get_thumb_dir(get_post('dir'));
	$files = get_files(get_post('dir'));
	$main_thumb = get_dir_thumbs(array('path' => get_post('dir'), 'name' => ''), 1);

	echo myjson_encode(array(
		'imgs' => filter_pics($files, 0),
		'dirs' => filter_dirs($files, 0),
      'thumb' => $thumb_dir.'/'.$main_thumb[0],
      'thumb_dir' => $thumb_dir,
		'json' => merge_json(get_json(get_post('dir')), get_hidden_json(get_post('dir'))),
      'url' => get_dir_url(get_post('dir')),
      'gpx' => get_gpx_file_path(get_post('dir')),
	));
}

function get_todo_list_action() {
	$thumbs_to_generate = get_missing_thumbs(get_post('dir'));
	echo myjson_encode(array(
		'imgs' => $thumbs_to_generate,
	));
}

function write_json_action() {
	write_json(get_post('dir').'/'.get_post('updated'), get_post('updated'));
	write_json(get_post('dir')); // Also update the parent dir
	echo myjson_encode(array('success' => 'ok'));
}

function update_json_action() {
	write_json(get_post('dir')); // Also update the parent dir
	echo myjson_encode(array('success' => 'ok'));
}


function clean_cache_action() {
	$del_files = clean_dir(get_post('dir'));
   echo myjson_encode(array('deleted_files' => $del_files));
}

function create_thumbs_action() {
	create_thumbs(get_post('dir'), get_post('img'));
	echo myjson_encode(array('success' => 'ok'));
}

function set_thumb_action() {
	if(isset($_GET['upfile'])) {
		/* Isn't it a bit unsafe? Should at least check the mime but no function exists */
		$input = fopen("php://input", "r");
		$temp = tempnam(sys_get_temp_dir(), 'th');
		$tempf = fopen($temp, "w");
        $realSize = stream_copy_to_stream($input, $tempf);
		fclose($input);
		set_thumb(get_post('dir').'/'.get_post('updated'), $temp);
	} else {
		if(get_post('img') == 'index.jpg')
			return;
		set_thumb(get_post('dir').'/'.get_post('updated'), get_post('dir').'/'.get_post('updated').'/'.get_post('img'));
	}
	write_json(get_post('dir'));
	echo myjson_encode(array('success' => 'ok', 'path' => get_thumb_dir(get_post('dir').'/'.get_post('updated'))));
}

function upload_gpx_action() {
   if(!isset($_GET['upfile']))
      die("Hack");
   $input = fopen("php://input", "r");
   $temp = tempnam(sys_get_temp_dir(), 'th');
   $tempf = fopen($temp, "w");
   $realSize = stream_copy_to_stream($input, $tempf);
   fclose($input);
   set_gpx(get_post('dir').'/'.get_post('updated'), $temp);
   echo myjson_encode(array('success' => 'ok'));
}

function remove_gpx_action() {
   remove_gpx(get_post('dir').'/'.get_post('updated'));
   write_json(get_post('dir').'/'.get_post('updated'), get_post('updated'));
   echo myjson_encode(array('success' => 'ok'));
}

?>
