<?php


function get_fail_pic($dir) {
   $c = count(explode("/", $dir['path']));
   $path = '../';
   for($i = 0; $i < $c; $i++) {
      $path .= '../';
   }
   $path .= 'themes/_common/fail.jpg';
   return $path;
}

function get_dir_thumbs($directory, $limit = 0) {
	$val = array();
	if(!is_dir(get_thumb_dir($directory['path'].'/'.$directory['name']))) {
		$val[] = get_fail_pic($directory);
		return $val;
	}

	$dir = opendir(get_thumb_dir($directory['path'].'/'.$directory['name']));
	$i = 0;
	if(file_exists(get_thumb_dir($directory['path'].'/'.$directory['name']).'/index_m.jpg')) {
		$val[] = 'index_m.jpg';
		$i++;
	}
	if($i == $limit && $i != 0)
		return $val;
	while ($File = readdir($dir)){
		$count = strlen($File);
		if($count > 6 && $File[$count-5] == 'm' && $File[$count-6] == '_' && $File != 'index_m.jpg') {
			$val[] = $File;
			$i++;
			if($i == $limit)
				break;
		}
	}
	if(count($val) == 0) {
		$val[] = get_fail_pic($directory);
	}
	return $val;
}


function get_dir_url($dir) {
   global $pics_dir;
   $path_only = implode("/", (explode('/', $_SERVER["REQUEST_URI"], -1)));
	return 'http://'.$_SERVER['SERVER_NAME'].str_replace("admin", "", simplify($path_only)).'#'.str_replace($pics_dir.'/', "", $dir);
}

function get_gpx_url($dir) {
   $path_only = implode("/", (explode('/', $_SERVER["REQUEST_URI"], -1)));
	return 'http://'.$_SERVER['SERVER_NAME'].str_replace("admin", "", simplify($path_only)).str_replace('../', "", $dir);
}
function get_gpx_upload_path($dir) {
	return get_json_dir($dir).'/data.gpx';
}
function get_gpx_file_path($dir) {
	$default_path = get_gpx_upload_path($dir);
	if(file_exists($default_path))
		return $default_path;

	$gpx = filter_gpx(get_files($dir), 1);
	if(count($gpx))
		return $gpx[0]['path'].'/'.$gpx[0]['name'];

	return '';
}
function set_gpx($dir, $file) {
   @mkdir(dirname(get_gpx_upload_path($dir)), 0777); 
   copy($file, get_gpx_upload_path($dir));
}
function remove_gpx($dir) {
	$gpx = get_gpx_file_path($dir);
	if($gpx != '')
		unlink($gpx);
}

/* TODO faces & JSON? */
function clean_dir($dir) {
   global $thumbs_dir, $pics_dir, $jsons_dir;
   $ret = 0;
   $ret_a = array();

   if(is_dir(get_thumb_dir($dir))) {
	   $files = get_files(get_thumb_dir($dir));
	   foreach($files as $f) {
		   $pic = str_replace($thumbs_dir, $pics_dir, $f['path'].'/'.$f['name']);
		   $thumb = $f['path'].'/'.$f['name'];

		   if(is_dir($thumb) && !is_dir($pic)) {
			   rrmdir($thumb);
			   $ret++;
			   $ret_a[] = $thumb;
		   } else if(is_thumb($f) && !file_exists(orig_pic($f)) && !is_thumb_index($f)) {
			   unlink($thumb);
			   $ret++;
			   $ret_a[] = $thumb;
		   }
	   }
   }

   if(is_dir(get_json_dir($dir))) {
	   $files = get_files(get_json_dir($dir));
	   foreach($files as $f) {
		   $pic = str_replace($jsons_dir, $pics_dir, $f['path'].'/'.$f['name']);
		   $json = $f['path'].'/'.$f['name'];
		   if(is_dir($json) && !is_dir($pic)) {
			   rrmdir($json);
			   $ret++;
			   $ret_a[] = $json;
		   } 
	   }
   }

   //TODO:faces?

   write_json($dir);
   return array('nb' => $ret, 'files' => $ret_a);
}

?>
