<?php

function get_json($dir) {
	if(file_exists(get_json_dir($dir).'/cache.json'))
		return json_decode(file_get_contents(get_json_dir($dir).'/cache.json'), true);
	else
		return array();
}

function get_hidden_json_name($dir) {
	$name = sha1(rand()).".json";
	if(!($d = @opendir(get_json_dir($dir))))
	   return $name;

	while($f = readdir($d)) {
		if(file_extension($f) == "json" && $f != "cache.json")
			return $f;
	}
	return $name;
}
function get_hidden_json($dir) {
	if(file_exists(get_json_dir($dir).'/'.get_hidden_json_name($dir)))
		return json_decode(file_get_contents(get_json_dir($dir).'/'.get_hidden_json_name($dir)), true);
	else
		return array();
}

function write_json($dir, $dirname = null) {
	$files = get_files($dir);
	$old_json = get_json($dir);
	$old_hidden_json = get_hidden_json($dir);
	$json = array();
	$hidden_json = array();

	/* Directory parsing */
	$directories = filter_dirs($files);
	if(count($directories) > 0) {
		$i = 0;
		$dirs = array();
		$hidden_dirs = array();
      foreach($directories as $d) {
         $was_hidden = dir_in_json($d['name'], $old_hidden_json);
			if($d['name'] != get_post('updated') && !dir_in_json($d['name'], $old_json) && !$was_hidden)
				continue;
			$js = array(
					'ID' => $i++,
					'url' => $d['name'],
					'thumbs' => get_dir_thumbs_cached($d, 5, $was_hidden?$old_hidden_json:$old_json),
					'descr' => get_description($d['name'], $was_hidden?$old_hidden_json:$old_json),
				);
			if(is_starred($d['name'], $was_hidden?$old_hidden_json:$old_json))
				$js['starred'] = true;
			if(($d['name'] == get_post('updated') && is_hidden($d['name'])) || ($d['name'] != get_post('updated') && $was_hidden))
				$hidden_dirs[] = $js;
			else
				$dirs[] = $js;
		}
		$json['dirs'] = $dirs;
		$hidden_json['dirs'] = $hidden_dirs;
	} 

	$pictures = filter_pics($files);
	if(count($pictures) > 0) {
		sort($pictures);

		$original = get_original_imgs($dir);

		$pics = array();
		foreach($pictures as $p) {
			$pics[] = array(
				'url' => $p['name'],
				'original' => isset($original[$p['name']])?1:0,
			);
		}
		$json['pics'] = $pics;
	} 

	/* Video parsing */
	$movies = filter_movies($files);
	if(count($movies) > 0) {
		sort($movies);

		$movs = array();
		$previous_name = "";
		foreach($movies as $m) {
			$current_name = substr(basename($m['name']), 0, -4);
			if($current_name == $previous_name) {
				$movs[count($movs) - 1]['url'][] = $m['name'];
			} else {
				$movs[] = array(
					'url' => array($m['name']),
				);
			}
			$previous_name = $current_name;
		}
		$json['vids'] = $movs;
	}
	/* GPS parsing */
   $json['gpx'] = get_gpx($dir, $dirname, $old_json);
   $json['gps'] = get_gps($dir, $dirname, $old_json);
   $json['gpxtype'] = get_gpxtype($dirname, $old_json);

	/* Description */
	$json['descr'] = get_json_entry($dirname, $old_json, 'descr', false);

	
	
	if(!is_dir(get_json_dir($dir)))
		@mkdir(get_json_dir($dir), 0777, true);
	file_put_contents(get_json_dir($dir).'/cache.json', myjson_encode($json));
	if(count($hidden_json) > 0) 
		file_put_contents(get_json_dir($dir).'/'.get_hidden_json_name($dir), myjson_encode($hidden_json));
}

function get_gps($dir, $dirname, $old_json) {
   if(!$dirname || get_post('sel_gps') == '' || get_post('sel_gps') == 'everytrail')
      return get_json_entry($dirname, $old_json, 'gps', false);
   else
      return '';
}
function get_gpx($dir, $dirname, $old_json) {
   if(!$dirname)
      return get_json_entry($dirname, $old_json, 'gpx', false);
   else if(get_post('sel_gps') == 'gpx') 
      return str_replace('../', '', get_gpx_file_path($dir));
   else
      return '';
}
function get_gpxtype($dir, $json) {
	return get_json_entry($dir, $json, 'gpxtype', true);
}
function get_description($dir, $json) {
	return get_json_entry($dir, $json, 'descr', true);
}
function is_starred($dir, $json) {
	$val = get_json_entry($dir, $json, 'starred', true);
	return $val === true || $val === "true";
}
function is_hidden($dir) {
	if(isset($_POST['hidden'])) {
		return $_POST['hidden'] === true || $_POST['hidden'] === "true";
	}
	return false;
}
function dir_in_json($dir, $json) {
	return get_json_entry($dir, $json, 'url', true) != '';
}
function get_dir_thumbs_cached($dir, $limit, $json) {
   $thumbs_cached = '';
   if(get_post('updated') != $dir['name'])
      $thumbs_cached = get_json_entry($dir['name'], $json, 'thumbs', true);
	return ($thumbs_cached != '')?$thumbs_cached:get_dir_thumbs($dir, $limit);
}
function get_json_entry($dir, $json, $key, $lookup_dirs) {
	$dir = forceUTF8($dir);

   /* First, check if the value is to be updated */
   $updated = get_post('updated');
	if($updated != '' && $updated == $dir && isset($_POST[$key])) {
		return get_post($key);
	}

	/* Next, parse the JSON */
	if($lookup_dirs) {
		if($json == null || !isset($json['dirs']) || $json['dirs'] == null)
			return '';
		foreach($json['dirs'] as $d) {
			if($d['url'] != null && $d['url'] == $dir) {
				return (!isset($d[$key]) || $d[$key] == null) ? '' : $d[$key];
			}
		}
		return '';
	} else {
		if($json == null || !isset($json[$key]) || $json[$key] == null)
			return '';
		else
			return $json[$key];
	}
}

function merge_json($json1, $json2) {
	if(!isset($json2['dirs']))
		return $json1;
	if(!isset($json1['dirs'])) {
		$json1['dirs'] = $json2['dirs'];
		return $json1;
	}
	foreach($json2['dirs'] as $dir) {
		$dir['hidden'] = true;
		$json1['dirs'][] = $dir;
	}
	return $json1;
}
?>
