<?php

/**
 * Thumbs generation functions
 * - get_missing_thumbs(dir) : returns the list of pictures that miss at least one thumb.
 * - create_thumbs(pic) : creates the thumbs of pic
 * - get_original_imgs(dir) : get the list of images which size is > big thumbnail size in a dir
 */

function get_missing_thumbs($dir) {
	$ret = array();
	$pics = filter_pics(get_files($dir));
   foreach($pics as $pic) {
		$file_date = filemtime($pic['path'].'/'.$pic['name']);
		$base_name = substr($pic['name'], 0, -4);
		$base_ext = file_extension($pic['name']);
		$big_pic = get_thumb_dir($dir).'/'.$base_name.'_r.'.$base_ext;
		$big_thumb = get_thumb_dir($pic['path']).'/'.$base_name.'_b.'.$base_ext;
		$small_thumb = get_thumb_dir($pic['path']).'/'.$base_name.'_m.'.$base_ext;
      $crop_thumb = get_thumb_dir($pic['path']).'/'.$base_name.'_c.'.$base_ext;
		if(!file_exists($big_pic) || (filemtime($big_pic) < $file_date) || !file_exists($big_thumb) || (filemtime($big_thumb) < $file_date) || !file_exists($small_thumb) || (filemtime($small_thumb) < $file_date) || !file_exists($crop_thumb) || (filemtime($crop_thumb) < $file_date)) {
			$ret[] = $pic;		
		}
	}
	return $ret;
}

// Create a thumb of size (dest_width, dest_height). If dest_height > 0, crop ; if dest_height < 0 reduce ; if dest_height == 0, no constraint on height.
function create_thumb_gd($file, $thumb, $dest_width, $dest_height = 0) {
	$base_ext = file_extension($file);
	if($base_ext == "JPG" || $base_ext == "jpg") {
		$source = @imagecreatefromjpeg($file); 
	} else if ($base_ext == "GIF" || $base_ext == "gif") {
		$source = @imagecreatefromgif($file);
	} else if ($base_ext == "PNG" || $base_ext == "png") {
		$source = @imagecreatefrompng($file);
	} else {
		$source = @imagecreatefromjpeg($file); 
	}
	if($source == NULL) {
		$err = error_get_last();
		die("Invalid file, aborting. ".$err['message']);
	}
	$orig_w = $src_width  = imagesx($source); 
	$orig_h = $src_height = imagesy($source); 

	$orig_x = $orig_y = 0;

	if($dest_height > 0) { // contraint on width AND height; find the correct crop and center
		if(((int)(100*$src_width/$src_height)) < ((int)(100*$dest_width/$dest_height))) {
			$src_width = (int)($src_height*$dest_width/$dest_height);
		} else if(((int)(100*$src_width/$src_height)) > ((int)(100*$dest_width/$dest_height))) {
			$src_height = (int)($src_width*$dest_height/$dest_width);
		}

		if($src_width > $orig_w)
			$src_width = $orig_w;
		if($src_height > $orig_h)			
			$src_height = $orig_h;
		
		if(((int)(100*$src_width/$src_height)) < ((int)(100*$dest_width/$dest_height))) {
			$src_height = (int)($src_width*$dest_height/$dest_width);
		} else if(((int)(100*$src_width/$src_height)) > ((int)(100*$dest_width/$dest_height))) {
			$src_width = (int)($src_height*$dest_width/$dest_height);
		}

		// Lets center the picture
		$orig_x = - ($src_width - $orig_w) / 2;
		$orig_y = - ($src_height - $orig_h) / 2;
	} else { // else reduce
		if ($src_width < $dest_width) {
			$dest_width = $src_width;
		}
		$tmp_dest_height = $src_height * $dest_width / $src_width;
		if($dest_height != 0 && $tmp_dest_height > -$dest_height) {
			$dest_height = -$dest_height;
			$dest_width = $src_width * $dest_height / $src_height;
		} else {
			$dest_height = $tmp_dest_height;
		}
	}

	$im = imagecreatetruecolor ($dest_width, $dest_height)  
		or die ("ImageCreateTrueColor failed !");  

	imagecopyresampled($im, $source, 0, 0, $orig_x, $orig_y, $dest_width, $dest_height, $src_width, $src_height); 

	imagejpeg ($im, $thumb, 98);  
	imagedestroy($im);
	imagedestroy($source);
}

function create_thumb_imagick($file, $thumb, $dest_width, $dest_height = 0) {
   global $convert, $quality;
   if(!file_exists($file))
      die("$file does not exist");
   if($convert == "" || !file_exists($convert))
      return create_thumb_gd($file, $thumb, $dest_width, $dest_height);

   list($src_width, $src_height) = getimagesize($file);
   if ($src_width < $dest_width) {
      $dest_width = $src_width;
   }
   $tmp_dest_height = $src_height * $dest_width / $src_width;
   if($dest_height != 0 && $tmp_dest_height > -$dest_height) {
      $dest_height = -$dest_height;
      $dest_width = $src_width * $dest_height / $src_height;
   } else {
      $dest_height = $tmp_dest_height;
   }
   exec($convert.' "'.$file.'" -quality '.$quality.' -resize '.$dest_width.'x'.$dest_height.' "'.$thumb.'"');
}


function create_thumb($file, $thumb, $dest_width, $dest_height = 0) {
   if($dest_width > 500 || $dest_height > 500) {
      create_thumb_imagick($file, $thumb, $dest_width, $dest_height);
   } else {
      create_thumb_gd($file, $thumb, $dest_width, $dest_height);
   }
}

function duplicate_thumb($orig, $dest) {
	copy($orig, $dest);
}

function set_thumb($dir, $file) {
	global $big_pic_width, $big_pic_height;
	if(!is_dir(get_thumb_dir($dir).'/'))
		@mkdir(get_thumb_dir($dir).'/', 0777, true);

	$big_thumb = get_thumb_dir($dir).'/index_b.jpg';
	if(file_exists($big_thumb))
		unlink($big_thumb);
	$small_thumb = get_thumb_dir($dir).'/index_m.jpg';
	if(file_exists($small_thumb))
		unlink($small_thumb);
	$crop_thumb = get_thumb_dir($dir).'/index_c.jpg';
	if(file_exists($crop_thumb))
		unlink($crop_thumb);

	$file_date = filemtime($file);
	$base_name = substr(basename($file), 0, -4);
	$base_ext = file_extension($file);
	$obig_thumb = get_thumb_dir($dir).'/'.$base_name.'_b.'.$base_ext;
	$osmall_thumb = get_thumb_dir($dir).'/'.$base_name.'_m.'.$base_ext;
	$ocrop_thumb = get_thumb_dir($dir).'/'.$base_name.'_c.'.$base_ext;

	if(file_exists($obig_thumb) && filemtime($obig_thumb) >= $file_date)
		duplicate_thumb($obig_thumb, $big_thumb);
	else
		create_thumb($file, $big_thumb, 350);

	if(file_exists($osmall_thumb) && filemtime($osmall_thumb) >= $file_date)
		duplicate_thumb($osmall_thumb, $small_thumb);
	else
		create_thumb($file, $small_thumb, 150);

	if(file_exists($ocrop_thumb) && filemtime($ocrop_thumb) >= $file_date)
		duplicate_thumb($ocrop_thumb, $crop_thumb);
	else
		create_thumb($file, $crop_thumb, 200, 150);
}

function create_thumbs($dir, $file) {
	global $big_pic_width, $big_pic_height;
	$base_name = substr($file, 0, -4);
	$base_ext = file_extension($file);
	if(!is_dir(get_thumb_dir($dir).'/'))
		@mkdir(get_thumb_dir($dir).'/', 0777, true);

	$file_date = filemtime($dir.'/'.$file);
	$big_pic = get_thumb_dir($dir).'/'.$base_name.'_r.'.$base_ext;
	$big_thumb = get_thumb_dir($dir).'/'.$base_name.'_b.'.$base_ext;
	$small_thumb = get_thumb_dir($dir).'/'.$base_name.'_m.'.$base_ext;
	$crop_thumb = get_thumb_dir($dir).'/'.$base_name.'_c.'.$base_ext;
	if(!file_exists($big_pic) || filemtime($big_pic) < $file_date)
		create_thumb($dir.'/'.$file, $big_pic, $big_pic_width, -$big_pic_height);
	if(!file_exists($big_thumb) || filemtime($big_thumb) < $file_date)
		create_thumb($big_pic, $big_thumb, 350);
	if(!file_exists($small_thumb) || filemtime($small_thumb) < $file_date)
		create_thumb($big_thumb, $small_thumb, 150);

	
	if(!file_exists($crop_thumb) || filemtime($crop_thumb) < $file_date) {
		list($width, $height, $type, $attr) = @getimagesize($big_thumb);
		if($height >= 150)
			create_thumb($big_thumb, $crop_thumb, 200, 150);
		else
			create_thumb($big_pic, $crop_thumb, 200, 150);
	}
}

function get_original_imgs($directory) {
	global $big_pic_width;
	$ret = array();
	if(!is_dir($directory))
		return $ret;

	$old_dir = getcwd();
	chdir($directory);

	$d = opendir('.');
	while ($file = readdir($d)){
		list($width, $height, $type, $attr) = @getimagesize($file);
		if($width > $big_pic_width)
			$ret[$file] = 1;
	}

	chdir($old_dir);
	return $ret;
}

function is_thumb($file) {
   $is_mini=substr($file['name'],-6,2);
   if($is_mini!="_m" && $is_mini!="_b" && $is_mini != "_c" && $is_mini != "_r")
      return false;
   return true;
}

function is_thumb_index($file) {
   $name = substr($file['name'], 0, -6);
   return $name == 'index';
}

/* /!\ assumes that the file is a thumbnail */
function orig_pic($file) {
   global $pics_dir, $thumbs_dir;
   $ext = file_extension($file['name']);
   $full_file = $file['path'].'/'.$file['name'];
   $pic = str_replace($thumbs_dir, $pics_dir, $full_file);
   $name = substr($pic, 0, -6).'.'.$ext;
   return $name;
}

?>
