<?php

set_include_path("./pages/options/php");
require_once('options.php');
require_once('diff.php');
require_once('update.php');

function change_action() {
   global $AVERSION;

   $new_values = get_options_post();
   $template = new liteTemplate();
   $template->file('pages/options/tpl/config.tpl');
   $template->assign($new_values);
   $template->assign(array('configv' => $AVERSION));

   @rename('config.php', 'config.php.bak');
   if(@file_put_contents('config.php', $template->returnTpl()) === FALSE) {
      main_action('fail');
      return;
   }

   $langs = getLangs();
   $template = new liteTemplate();
   $template->file('pages/options/tpl/index.tpl');
   $template->assignTag('BALISE', '1', getThemes());
   $template->assignTag('BALISE', '2', $langs);
   $template->assign(array('TR' => getLangContent($langs['LANG'][0])));

   $content = file_get_contents('../index.html');
   @rename('../index.html', '../index.html.bak');
   if(@file_put_contents('../index.html', preg_replace('/<!-- Autogenerated, do not modify by hand -->(.*?)<!-- Autogenerated -->/ms', "<!-- Autogenerated, do not modify by hand -->\n".$template->returnTpl()."\t<!-- Autogenerated -->", $content)) === FALSE) {
      main_action('fail2');
      return;
   }

   header('Location: index.php?action=options.changed');
}

function changed_action() {
	main_action('changed');
}

function update_action() {
   main_action('update');
}

function main_action($action = '') {
	$template = new liteTemplate();
	$template->showPage('options');

	$options = get_options();

	$descr = array();
	$heads = array();
	$inputs = array();
	$last_head = '';
	foreach($options as $meta) {
		$inputs[] = $template->createInput($meta);
		if($meta['cat'] != $last_head) {
			$heads[] = '<h2 class="translate">'.$meta['cat'].'</h2>';
			$last_head = $meta['cat'];
		} else {
			$heads[] = '';
		}
		$descr[] = $meta['id'];
	}
	$template->assignTag('BALISE', '2', array(
				'HEAD' => $heads,
				'DESCR' => $descr,
				'INPUT' => $inputs,
				));

	$template->assign(array('DISPLAY_CHANGED' => ($action == 'changed')?'block':'none'));
	$template->assign(array('DISPLAY_UPDATE' => ($action == 'update')?'block':'none'));
	$template->assign(array('DISPLAY_FAIL' => ($action == 'fail')?'block':'none'));
	$template->assign(array('DISPLAY_FAIL2' => ($action == 'fail2')?'block':'none'));
	$template->view();
}

function updategal_action() {
   global $lang;
   if(!isset($lang))
      $lang = 'en';
	$template = new liteTemplate();
	$template->file('./pages/options/tpl/update.tpl');
	$template->assign(array('lang' => $lang));
	$template->view();
}

function get_files_to_update_action() {
	echo json_encode(get_update_zip());
}

function update_file_action() {
	echo json_encode(update_file(get_post('ufile'), get_post('binary')));
}

function update_file_manually_action() {
	echo json_encode(update_file_manually(get_post('ufile'), get_post('ucontent')));
}

function finish_merge_action() {
	$res = finish_merge(json_decode(get_post('files'), true));
	echo json_encode(array(
		'success' => (count($res) == 0),
		'err' => $res
	));
}

function check_rights_action() {
	$res = check_rights(json_decode(get_post('files'), true));
	echo json_encode(array(
		'success' => (count($res) == 0),
		'err' => $res
	));
}
