<?php

function get_options() {
	global $adm_pwd, $big_pic_width, $big_pic_height, $quality, $face_pub, $face_secret, $face_namespace, $pages, $convert, $lang, $ulang, $utheme, $gpx_type;

	return array(
		array('id' => 'adm_pwdv', 'type' => 'password', 'val'=> $adm_pwd, 'cat' => 'Global', 'default' => ''),
		array('id' => 'langv', 'type' => 'select', 'val'=> $lang, 'cat' => 'Global', 'default' => 'en', 'vals' => array('en' => 'English', 'fr' => 'Fran&ccedil;ais')),
		array('id' => 'gpx_typev', 'type' => 'select', 'val'=> $gpx_type, 'cat' => 'GPX', 'default' => 'satelitte', 'vals' => array('satellitte' => 'Satellitte', 'roadmap' => 'Road Map', 'terrain' => 'Terrain')),
		array('id' => 'uthemev', 'type' => 'select', 'val'=> $utheme, 'cat' => 'UserOpt', 'default' => 'default', 'vals' => getThemesOpt()),
		array('id' => 'ulangv', 'type' => 'select', 'val'=> $ulang, 'cat' => 'UserOpt', 'default' => 'en', 'vals' => getLangsOpt()),
		array('id' => 'big_pic_widthv', 'type' => 'text', 'val'=> $big_pic_width, 'cat' => 'Thumbs', 'default' => 900),
		array('id' => 'big_pic_heightv', 'type' => 'text', 'val'=> $big_pic_height, 'cat' => 'Thumbs', 'default' => 800),
		array('id' => 'qualityv', 'type' => 'text', 'val'=> $quality, 'cat' => 'Thumbs', 'default' => 96),
		array('id' => 'convertv', 'type' => 'text', 'val'=> $convert, 'cat' => 'ImageMagick', 'default' => '/usr/bin/convert'),
	);
}

function get_options_post() {
   $opts = get_options();
   $ret = array();
   foreach($opts as $opt) {
      if($opt['type'] == 'text' || $opt['type'] == 'select') {
         $ret[$opt['id']] = get_post($opt['id']);
      } else if($opt['type'] == 'password') {
         $ret[$opt['id']] = get_post($opt['id']);
         if($ret[$opt['id']] != $opt['val'] && $ret[$opt['id']] != '')
            $ret[$opt['id']] = sha1($ret[$opt['id']]);
      } else if($opt['type'] == 'checkbox') {
         $ret[$opt['id']] = isset($_POST[$opt['id']]);
      }
   }
   return $ret;
}

function getBGFG($file) {
	if(!file_exists($file))
		return NULL;
	$css = file_get_contents($file);
	if(!preg_match('/body {(.*?)}/ms', $css, $body_css_a))
		return NULL;
	$body_css = $body_css_a[1];
	if(!preg_match('/background-color:(.*?);/ms', $css, $bg_a))
		return NULL;
	if(!preg_match('/[^-]color:(.*?);/ms', $css, $fg_a))
		return NULL;
	return array('BG' => $bg_a[1], 'FG' => $fg_a[1]);
}

function getThemes() {
	global $utheme;
	if(get_post('uthemev') != '')
		$utheme = get_post('uthemev');

	$files = filter_dirs(get_files('../themes'));
	$ret = array(
		'NAME' => array(),
		'BG' => array(),
		'FG' => array(),
	);
	foreach($files as $file) {
		if($file['name'][0] == '_')
			continue;
		$bgfg = getBGFG($file['path'].'/'.$file['name'].'/main.css');
		if(!$bgfg)
			continue;

		if($utheme && $file['name'] == $utheme) { //default = first element
			array_unshift($ret['NAME'], $file['name']);
			array_unshift($ret['BG'], $bgfg['BG']);
			array_unshift($ret['FG'], $bgfg['FG']);
		} else {
			$ret['NAME'][] = $file['name'];
			$ret['BG'][] = $bgfg['BG'];
			$ret['FG'][] = $bgfg['FG'];
		}
	}

	return $ret;
}

function getThemesOpt() {
	$avail_themes_raw = getThemes();
	$avail_themes = array();
	foreach($avail_themes_raw['NAME'] as $t)
		$avail_themes[$t] = $t;
	return $avail_themes;
}

function getLangs() {
	global $ulang;
	if(get_post('ulangv') != '')
		$ulang= get_post('ulangv');

	$files = get_files('../scripts/lang');
	$ret = array( 'LANG' => array() );
	foreach($files as $file) {
		if($file['name'][0] == '_')
			continue;
		if($ulang && $file['name'] == $ulang.'.js') { //default = first element
			array_unshift($ret['LANG'], str_replace('.js', '', $file['name']));
		} else {
			$ret['LANG'][] = str_replace('.js', '', $file['name']);
		}
	}
	return $ret;
}

function getLangContent($lang) {
	return file_get_contents('../scripts/lang/'.$lang.'.js');
}

function getLangsOpt() {
	$avail_lang_raw = getLangs();
	$avail_lang = array();
	foreach($avail_lang_raw['LANG'] as $l)
		$avail_lang[$l] = $l;
	return $avail_lang;
}
