<?php

$GLOBALS['patch_dir'] = "./patch";

function unzip($zipfile) {
    $zip = zip_open($zipfile);
    while ($zip_entry = zip_read($zip))    {
        zip_entry_open($zip, $zip_entry);
        if (substr(zip_entry_name($zip_entry), -1) == '/') {
            $zdir = substr(zip_entry_name($zip_entry), 0, -1);
            if (file_exists($zdir)) {
                trigger_error('Directory "<b>' . $zdir . '</b>" exists', E_USER_ERROR);
                return false;
            }
            mkdir($zdir);
        }
        else {
            $name = zip_entry_name($zip_entry);
            if (file_exists($name)) {
                trigger_error('File "<b>' . $name . '</b>" exists', E_USER_ERROR);
                return false;
            }
            $fopen = fopen($name, "w");
            fwrite($fopen, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)), zip_entry_filesize($zip_entry));
        }
        zip_entry_close($zip_entry);
    }
    zip_close($zip);
    return true;
}

function get_update_zip() {
   global $AVERSION, $patch_dir;

   rrmdir($patch_dir);
   $ret = mkdir($patch_dir,0777,true);
   if(!$ret)
      return array('success' => FALSE);


   $NVERSION = file_get_contents("http://update.en-vadrouille.net/VERSION");
   if($NVERSION == FALSE)
      return array('success' => FALSE);
   $rev = preg_replace('/remote_check_version\({"version":(\d+)}\).*/s', "$1", $NVERSION);

   if(!copy("http://update.en-vadrouille.net/patch-stable-$AVERSION-stable-$rev.zip", "$patch_dir/patch.zip"))
      return array('success' => FALSE);

   chdir($patch_dir);
   unzip("patch.zip");
   return array(
      'success' => TRUE,
      'json' => json_decode(file_get_contents("diff.json"), true),
   );
}

function update_file($file, $binary) {
   global $patch_dir;
   $curr_file = "../$file";
   $ret = copy("$patch_dir/envadrouille/$file.last", "$patch_dir/envadrouille/$file.merged");
   return array('success' => $ret, 'reason' => "brutal update");
}

function update_file_manually($file, $content) {
   global $patch_dir;
   $ret = file_put_contents("$patch_dir/envadrouille/$file.merged", $content);
   return array(
      'success' => $ret,
   );
}

function check_rights($files) {
   global $patch_dir;
   $err = array();
   //check write permission before destroying everything
   foreach($files as $f) {
      if(!file_exists('../'.$f['file'])) {
         @mkdir(dirname('../'.$f['file']), 0777, true);
      }
      $handle = @fopen('../'.$f['file'], "a+");
      if(!$handle) {
         $err[] = $f;
      } else {
         fclose($handle);
      }
   }
   return $err;
}

function finish_merge($files) {
   global $patch_dir;
   $err = check_rights($files);
   if(count($err))
      return $err;

   foreach($files as $ff) {
      $f = $ff['file'];
      $ret = rename("$patch_dir/envadrouille/$f.merged", '../'.$f);
      if(!filesize('../'.$f)) {
         unlink('../'.$f);
      }
   }
   return $err;
}
?>
