var animateContent = false;

function changeThemeLang(l) {
	if(l == 'fr') {
		config.tr['Back to the index'] = 'Retour  l\'index';
		config.tr['Partial result(s):'] = 'Rsultat(s) partiel(s)';
	}
}

function showHeader(data) {
	if(!data)
		return;
	var dirUrl = jGalleryModel.pageToUrl(jGallery.currentPage).split('/');
	document.title = 'Photos :: '+((dirUrl=='')?'Index':dirUrl[dirUrl.length-2]);
	if(dirUrl.length > 1) {
		dirUrl = dirUrl[dirUrl.length-2];
		var m = dirUrl.match( jGalleryModel.dirPattern );
		var title = dirUrl;
		if(m) 
			title = m[4];
		$('#content').append('<div class="subheader"><span class="title">'+title+'</span>'+(dirUrl!=''?'<span class="back"><a href="#" class="translate">['+jGalleryModel.translate('Back to the index')+']</a></span>':'')+'</div>');
	}
}
function centerPic(dir) {
	var img = dir.find('.imgc').find('img');
	img.css('opacity', 0).load(function() {
		$(this).css('position', 'relative').css('top', (dir.find('.imgc').height() - img.height() - 3) / 2).css('opacity', 1);
	});
}
function showDirs(data) {
	if(!data.dirs)
		return;

	var dirUrl = jGalleryModel.pageToUrl(jGallery.currentPage);
	for (var i in data.dirs) {
		var m = data.dirs[i].url.match( jGalleryModel.dirPattern );
		if(m) {  
			data.dirs[i].year = m[3]+'-'+m[2]+'-'+m[1];
			data.dirs[i].title = m[4];
		} else {
			data.dirs[i].title = data.dirs[i].url;
		}
		
		data.dirs[i].thumb = dirUrl+data.dirs[i].url+'/'+data.dirs[i].thumbs[0];
		$("#dirTpl").tmpl(data.dirs[i]).appendTo('#content');
		$('#dir'+i).click({url:data.dirs[i].url}, function(ev) {
			ev.preventDefault();
			jGallery.switchPage(dirUrl+ev.data.url);
		});
		centerPic($('#dir'+i));
	}
}
function showGps(data) {
	if(data.gps) {
		$("#everytrailTpl").tmpl({gps:data.gps}).appendTo('#content');
	} else if(data.gpx) {
		$("#gpsTpl").tmpl().appendTo('#content');
		jGallery.showGPX(data);
	}
}
function showPics(data) {
	if(!data.pics)
		return;
	var pics = [];
	for (var i in data.pics) {
		pics[i] = {
			ID:i,
			url:jGallery.currentPage,
			big:data.pics[i].url,
			thumb:data.pics[i].url.replace(/\.(.*)$/, "_b.$1"),
			original:data.pics[i].original
		};
	}
	$("#picsTpl").tmpl({Pics:pics, Num:3}).appendTo('#content');
	$("a[rel*='gal']").colorbox({slideshow:true, slideshowSpeed:3500, slideshowAuto:false, loop:false,
		maxWidth:'90%', maxHeight:'90%'
	});

	for (var i in data.pics) {
		$('#pic'+i+' img').load(function() {
			$(this).animate({opacity:1}, 'slow');
		});
	}
}
function showVids(data) {
	if(!data.vids)
		return;

	var dirUrl = jGalleryModel.pageToUrl(jGallery.currentPage);
	var vids = [];
	for (var i in data.vids) {
		vids[i] = {
			ID:i,
			vid:data.vids[i].url,
			path:dirUrl,
			h:360,
			w:640
		};
		$("#vidTpl").tmpl(vids[i]).appendTo('#content');
	}
}
function showError(data) {
	$("#errorTpl").tmpl(data).appendTo('#content');
}
function showSearch(dataFull, dataPartial, regs) {
	if(dataFull.length) {
		showSearchResults(dataFull, regs);
		$('#search_results').append('<br/><br/>');	
	}
	if(dataPartial.length) {
		$('#search_results').append('<b class="translate">'+jGalleryModel.translate('Partial result(s):')+'</b>');
		showSearchResults(dataPartial, regs);
	}
}
function showSearchResults(data, regs) {
	if(!data)
		return;
	for (var i in data) {
		var res = {};
		res.ID = data[i].ID;
		res.url = data[i].url;
		res.descr = data[i].descr;
		res.starred = data[i].starred;

		var m = data[i].url.match( jGalleryModel.dirPattern );
		if(m) {  
			res.year = jGallery.highlightText(m[3]+'-'+m[2]+'-'+m[1], regs);
			res.title = jGallery.highlightText(m[4], regs);
		} else {
			res.title = jGallery.highlightText(data[i].url, regs);
		}

		res.thumb = data[i].url+'/'+data[i].thumbs[0];
		$("#dirTpl").tmpl(res).appendTo('#search_results');
		$('#dir'+res.ID+' .descr').html(jGallery.highlightText($('#dir'+res.ID+' .descr').text(), regs));
		$('#dir'+res.ID).click({url:res.url}, function(ev) {
			ev.preventDefault();
			jGallery.switchPage(ev.data.url);
		});
		centerPic($('#dir'+res.ID));
	}
}
